#!/bin/bash
# A batch script to run DataMelt without IDE
# DataMelt project: http://datamelt.org/
# Contact dmelt@jwork.org

# assume Dmelt in the current directory.
export DMELT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"


args=$#
if [ $args == 0  ]
then
   echo "You did not specify a jython input file!"
   echo "This script runs DataMelt file in batch mode without the IDE editor"
   echo "TYPE: dmelt_batch.sh <file>.py <arguments>"
   exit 1;
fi

JAVA_HEAP_SIZE=2048


# set here home directory where the jehep.jar file is located 
JEHEP_HOME=${DMELT_DIR}

arguments="$@"

if which java >/dev/null; then
    _java=java
elif [[ -n "$JAVA_HOME" ]] && [[ -x "$JAVA_HOME/bin/java" ]];  then
    _java="$JAVA_HOME/bin/java"
else
    echo "No java detected! Please install it from https://java.com/download"; exit 0
fi

JEHEP_FILE="$JEHEP_HOME"/dmelt.jar
if [ ! -f $FILE ];
then
   echo "DMelt cannot be detected. Please change the variable DMELT_DIR to DataMelt location (with dmelt.jar)"
fi


################## do not edit ###############################
CLASSPATH="."
for i in ${JEHEP_HOME}/lib/*/*.jar
do
      CLASSPATH=$CLASSPATH:"$i"
done

# convert the unix path to windows
if [ "$OSTYPE" = "cygwin32" ] || [ "$OSTYPE" = "cygwin" ] ; then
   CLASSPATH=`cygpath --path --windows "$CLASSPATH"`
fi

LIBJEHEP=${JEHEP_HOME}"/lib/native/linux-i586/"
OS=`uname`
arch=`uname -m`


if [ "$OS" = "Darwin" ]; then
  echo "Running on Mac.."
  LIBJEHEP=${JEHEP_HOME}"/lib/native/macosx/"
fi

if [ "$OS" == "Linux" ]; then
if  [ $arch = i386 ]; then
            LIBJEHEP=$JEHEP_HOME"/lib/native/linux-i586/"
            echo "Running on Linux i386 .."
     elif [ $arch = "i486" ]; then
            LIBJEHEP=$JEHEP_HOME"/lib/native/linux-i586/"
            echo "Running on Linux i486 .."
     elif [ $arch = "i586" ]; then
            LIBJEHEP=$JEHEP_HOME"/lib/native/linux-i586/"
            echo "Running on Linux i586 .."          
     elif [ $arch = "i686" ]; then
            LIBJEHEP=$JEHEP_HOME"/lib/native/linux-i586/"
            echo "Running on Linux i686 .."
     elif [ $arch = "x86_64" ]; then
            LIBJEHEP=$JEHEP_HOME"/lib/native/linux-amd64/"
            echo "Running on Linux x86_64 .."
     else
        echo "Unsupported Architecture"
fi
fi

# some computers may run 32 bit java even on 64 bit
if [ $arch = "x86_64" ]; then
  $_java -d64 -version > /tmp/log_jhepwork 2>&1
  javacheck=`cat /tmp/log_jhepwork`
  if `echo ${javacheck} | grep "not supported" 1>/dev/null 2>&1`
  then
    LIBJEHEP=$JEHEP_HOME"/lib/native/linux-i586/"
    echo "Running a 32-bit JVM "
  else
    echo "Running a 64-bit JVM " 
fi
fi



# Add in your .jar files first
for i in $LIBJEHEP/*.jar
do
      CLASSPATH=$CLASSPATH:$i
done


JYTHON_HOME=${JEHEP_HOME}"/lib/jython"
CP=${JYTHON_HOME}"/jython.jar"
if [ ! -z "$CLASSPATH" ]
then
  CP=$CP:$CLASSPATH
fi



OPTJJ="-Djava.library.path=$LIBJEHEP -Dlog4j.configuration=$JEHEP_HOME/log4j.properties -Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.NoOpLog -Dcom.github.fommil.netlib.BLAS=com.github.fommil.netlib.F2jBLAS -Dcom.github.fommil.netlib.LAPACK=com.github.fommil.netlib.F2jLAPACK -Dcom.github.fommil.netlib.ARPACK=com.github.fommil.netlib.F2jARPACK"

# rebuild cache.. First time only
CACHE="${JYTHON_HOME}/cachedir/packages"
if [ ! -d $CACHE ];
then
   echo "Wait.. first-time optimization of Java packages for Jython"
   $_java  -mx${JAVA_HEAP_SIZE}m  -cp "$CP" $OPTJJ -Dpython.home=${JYTHON_HOME} jehep.utils.RunScript ${JYTHON_HOME}/optimize.py
fi

echo ${arguments}

# only for Jython
#$_java  -mx${JAVA_HEAP_SIZE}m  -classpath "$CP" $OPTJJ -Dpython.home=${JYTHON_HOME} \
#                     org.python.util.jython ${arguments}

# any script with the extension *.py, *.bsj, *.java, *rb
$_java  -mx${JAVA_HEAP_SIZE}m  -classpath "$CP" $OPTJJ -Dpython.home=${JYTHON_HOME} \
      jehep.utils.RunScript ${arguments}

# Note:
# Dcom.github.fommil.netlib switched to turn off native support for 
# https://github.com/fommil/netlib-java

