
from java.util import Random
from jhplot  import HPlot,P1D

# make main canvas
c1 = HPlot("Canvas",600,400, 2, 1)
c1.visible(1)
c1.setGTitle("Contour plots")

pp1=P1D("Contour plot 1")
pp2=P1D("Contour plot 2")

rand = Random()
for i in range(1000):
       # fill first
       x=10*rand.nextGaussian()
       y=3*rand.nextGaussian()
       pp1.add(x,y)
       # fill second
       x=20*rand.nextGaussian()
       y=20*x+50*rand.nextGaussian()
       pp2.add(x,y) 

c1.cd(1,1)
c1.setRange(-15,15,-10,10)
# set contour plot
c1.setContour(1)
# set number of color levels
c1.setContourLevels(7)
# set number of bins in X and Y 
c1.setContourBins(20,20)
c1.draw(pp1)

# fgo to next canvas
c1.cd(2,1)
c1.setAutoRange()
c1.setContour(1)
c1.draw(pp2)


# export to some image (png,eps,pdf,jpeg...)
# c1.export(Editor.DocMasterName()+".png")
