package net.hep.graphics.ObjectBrowser.Aspects;

/** Tracing Aspect.
  * <p><font color="#880088">
  * <pre>
  * $Log: Trace.aj,v $
  * Revision 1.1  2004/09/08 13:43:56  hrivnac
  * Log -> Trace
  *
  * </pre>
  * </font></p>
  * @version $Id: Trace.aj,v 1.1 2004/09/08 13:43:56 hrivnac Exp $
  * @author <a href="mailto:Julius.Hrivnac@cern.ch">J.Hrivnac</a> */
aspect Trace {
  
  /** Trace all executions, except itself. */
  pointcut trace() : execution(* *.*(..)) &&
                    !execution(* net.hep.graphics.ObjectBrowser.Aspects.Trace.*(..));
  
  /** Widen depth, adjust prefix, write out where we are. */
  before() : trace() {
    callDepth += 2;
    prefix = BLANKS.substring(0, callDepth);
    Object[] args = thisJoinPoint.getArgs();
    System.out.println(prefix + thisJoinPoint);
    for (int i = 0; i < args.length; i++) {
      System.out.println(prefix + ">  " + args[i]); // TBD: Java 1.5
      }
    }

  /** Shorten depth. */
  after() : trace() {
    callDepth -= 2;
    }
  
  private static int callDepth = -1;
  
  private static String BLANKS = "                                            ";
  
  private static String prefix;
    
  }
