% essential
function y = acosh(x)
	y = log(x+sign(x)*sqrt(x*x-1));
end


/*
@@GROUP
trigonometric
@SYNTAX
angle = ACOS(value)
@DOC
Returns the arc cosine of value.
@EXAMPLES
ACOS(1) = 0
ACOS(0) = 1.5707963267948966
@SEE
cos, acosh
*/


