## -*- texinfo -*-
## @deftypefn {Function File} {} acosd (@var{x})
## Compute the inverse cosine of an angle in degrees.
## @seealso{acos, cosd, asecd}
## @end deftypefn

function y = acosd (x)
  y = acos(x) .* 180 ./ pi;
end


/*
@GROUP
trigonometric
@SYNTAX
angle = acosd(value)
@DOC
Compute the inverse cosine of an angle in degrees.
@EXAMPLES
<programlisting>
.
</programlisting>
@NOTES
@SEE
cos, acosh, sin, asin, asinh
*/

