/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.JampackException;
import Jampack.Parameters;
import Jampack.Z;
import Jampack.Z1;
import Jampack.Zmat;

public class Zdiagmat {
    protected int order;
    protected int basex;
    protected double[] re;
    protected double[] im;
    public int n;
    public int bx;
    public int dx;

    public Zdiagmat(int order) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.order = order;
        this.getProperties();
        this.re = new double[this.n];
        this.im = new double[this.n];
    }

    public Zdiagmat(int order, Z val) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.order = order;
        this.getProperties();
        this.re = new double[this.n];
        this.im = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.re[i] = val.re;
            this.im[i] = val.im;
        }
    }

    public Zdiagmat(Z1 val) {
        Parameters.BaseIndexNotChangeable = true;
        this.bx = Parameters.BaseIndex;
        this.order = val.re.length;
        this.getProperties();
        this.re = new double[this.n];
        this.im = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.re[i] = val.re[i];
            this.im[i] = val.im[i];
        }
    }

    public Zdiagmat(Zmat A, int k) throws JampackException {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        if (k >= 0) {
            if (k >= A.ncol) {
                throw new JampackException("Diagonal out of range.");
            }
            this.order = Math.min(A.nrow, A.ncol - k);
            this.re = new double[this.order];
            this.im = new double[this.order];
            for (int i = 0; i < this.order; ++i) {
                this.re[i] = A.re[i][i + k];
                this.im[i] = A.im[i][i + k];
            }
        } else {
            if ((k = -k) >= A.nrow) {
                throw new JampackException("Diagonal out of range.");
            }
            this.order = Math.min(A.nrow - k, A.ncol);
            this.re = new double[this.order];
            this.im = new double[this.order];
            for (int i = 0; i < this.order; ++i) {
                this.re[i] = A.re[i + k][i];
                this.im[i] = A.im[i + k][i];
            }
        }
        this.getProperties();
    }

    public Zdiagmat(Zmat A) throws JampackException {
        this(A, 0);
    }

    public Zdiagmat(Zdiagmat D) {
        Parameters.BaseIndexNotChangeable = true;
        this.basex = Parameters.BaseIndex;
        this.order = D.order;
        this.getProperties();
        this.re = new double[this.n];
        this.im = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.re[i] = D.re[i];
            this.im[i] = D.im[i];
        }
    }

    public void getProperties() {
        this.bx = this.basex;
        this.dx = this.bx + this.order - 1;
        this.n = this.order;
    }

    public Z get(int ii) {
        return new Z(this.re[ii - this.bx], this.im[ii - this.bx]);
    }

    public Z get0(int i) {
        return new Z(this.re[i], this.im[i]);
    }

    public void put(int ii, Z val) {
        this.re[ii - this.bx] = val.re;
        this.im[ii - this.bx] = val.im;
    }

    public void put0(int i, Z val) {
        this.re[i] = val.re;
        this.im[i] = val.im;
    }
}

