/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SortedArrayList<T extends Comparable<T>>
extends ArrayList<T>
implements Serializable {
    private static final long serialVersionUID = -8728381865616791954L;

    public SortedArrayList(Collection<? extends T> c) {
        super(c);
        Collections.sort(this);
    }

    public SortedArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public SortedArrayList() {
    }

    @Override
    public boolean add(T e) {
        if (this.isEmpty()) {
            return super.add(e);
        }
        int ind = Collections.binarySearch(this, e);
        if (ind < 0) {
            ind = -(ind + 1);
        }
        if (ind > this.size()) {
            super.add(e);
        } else {
            super.add(ind, e);
        }
        return true;
    }

    @Override
    public void add(int index, T element) {
        this.add(element);
    }

    public T first() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)((Comparable)this.get(0));
    }

    public T last() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)((Comparable)this.get(this.size() - 1));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c.isEmpty()) {
            return false;
        }
        if (c.size() > this.size() * 3 / 2) {
            boolean did = super.addAll(c);
            if (did) {
                Collections.sort(this);
            }
            return did;
        }
        for (Comparable t : c) {
            this.add((T)t);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.addAll(c);
    }
}

