/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class QuickSort {
    private QuickSort() {
    }

    private static int med3(double[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static int med3(float[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    protected static void vecswap(double[] x, int a, int b, int n) {
        for (int i = 0; i < n; ++i) {
            QuickSort.swap(x, a++, b++);
        }
    }

    protected static void vecswap(float[] x, int a, int b, int n) {
        for (int i = 0; i < n; ++i) {
            QuickSort.swap(x, a++, b++);
        }
    }

    private static void vecswap(double[] x, int a, int b, int n, Collection<List<?>> paired) {
        for (int i = 0; i < n; ++i) {
            for (List<?> l : paired) {
                Collections.swap(l, a, b);
            }
            QuickSort.swap(x, a++, b++);
        }
    }

    private static void vecswap(float[] x, int a, int b, int n, Collection<List<?>> paired) {
        for (int i = 0; i < n; ++i) {
            for (List<?> l : paired) {
                Collections.swap(l, a, b);
            }
            QuickSort.swap(x, a++, b++);
        }
    }

    public static void swap(double[] array, int i, int j) {
        double tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    public static void swap(float[] array, int i, int j) {
        float tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    public static void swapC(double[] array, int i, int j) {
        double tmp_i = array[i];
        double tmp_j = array[j];
        if (tmp_i > tmp_j) {
            array[i] = tmp_j;
            array[j] = tmp_i;
        }
    }

    public static void swap(double[] array, int i, int j, Collection<List<?>> paired) {
        double t = array[i];
        array[i] = array[j];
        array[j] = t;
        for (List<?> l : paired) {
            Collections.swap(l, i, j);
        }
    }

    public static void swap(float[] array, int i, int j, Collection<List<?>> paired) {
        float t = array[i];
        array[i] = array[j];
        array[j] = t;
        for (List<?> l : paired) {
            Collections.swap(l, i, j);
        }
    }

    public static void sort(double[] x, int start, int end) {
        int pc;
        int pa;
        int a = start;
        int n = end - start;
        if (n < 7) {
            QuickSort.insertionSort(x, a, end);
            return;
        }
        int pm = a + n / 2;
        if (n > 7) {
            int pl = a;
            int pn = a + n - 1;
            if (n > 40) {
                int s = n / 8;
                pl = QuickSort.med3(x, pl, pl + s, pl + 2 * s);
                pm = QuickSort.med3(x, pm - s, pm, pm + s);
                pn = QuickSort.med3(x, pn - 2 * s, pn - s, pn);
            }
            pm = QuickSort.med3(x, pl, pm, pn);
        }
        double pivotValue = x[pm];
        int pb = pa = a;
        int pd = pc = end - 1;
        while (true) {
            if (pb <= pc && x[pb] <= pivotValue) {
                if (x[pb] == pivotValue) {
                    QuickSort.swap(x, pa++, pb);
                }
                ++pb;
                continue;
            }
            while (pc >= pb && x[pc] >= pivotValue) {
                if (x[pc] == pivotValue) {
                    QuickSort.swap(x, pc, pd--);
                }
                --pc;
            }
            if (pb > pc) break;
            QuickSort.swap(x, pb++, pc--);
        }
        int pn = end;
        int s = Math.min(pa - a, pb - pa);
        QuickSort.vecswap(x, a, pb - s, s);
        s = Math.min(pd - pc, pn - pd - 1);
        QuickSort.vecswap(x, pb, pn - s, s);
        s = pb - pa;
        if (s > 1) {
            QuickSort.sort(x, a, a + s);
        }
        if ((s = pd - pc) > 1) {
            QuickSort.sort(x, pn - s, pn);
        }
    }

    public static void insertionSort(double[] x, int start, int end) {
        for (int i = start; i < end; ++i) {
            for (int j = i; j > start && x[j - 1] > x[j]; --j) {
                QuickSort.swap(x, j, j - 1);
            }
        }
    }

    public static void sort(double[] x, int start, int end, Collection<List<?>> paired) {
        int pc;
        int pa;
        int a = start;
        int n = end - start;
        if (n < 7) {
            for (int i = a; i < end; ++i) {
                for (int j = i; j > a && x[j - 1] > x[j]; --j) {
                    QuickSort.swap(x, j, j - 1, paired);
                }
            }
            return;
        }
        int pm = a + n / 2;
        if (n > 7) {
            int pl = a;
            int pn = a + n - 1;
            if (n > 40) {
                int s = n / 8;
                pl = QuickSort.med3(x, pl, pl + s, pl + 2 * s);
                pm = QuickSort.med3(x, pm - s, pm, pm + s);
                pn = QuickSort.med3(x, pn - 2 * s, pn - s, pn);
            }
            pm = QuickSort.med3(x, pl, pm, pn);
        }
        double pivotValue = x[pm];
        int pb = pa = a;
        int pd = pc = end - 1;
        while (true) {
            if (pb <= pc && x[pb] <= pivotValue) {
                if (x[pb] == pivotValue) {
                    QuickSort.swap(x, pa++, pb, paired);
                }
                ++pb;
                continue;
            }
            while (pc >= pb && x[pc] >= pivotValue) {
                if (x[pc] == pivotValue) {
                    QuickSort.swap(x, pc, pd--, paired);
                }
                --pc;
            }
            if (pb > pc) break;
            QuickSort.swap(x, pb++, pc--, paired);
        }
        int pn = end;
        int s = Math.min(pa - a, pb - pa);
        QuickSort.vecswap(x, a, pb - s, s, paired);
        s = Math.min(pd - pc, pn - pd - 1);
        QuickSort.vecswap(x, pb, pn - s, s, paired);
        s = pb - pa;
        if (s > 1) {
            QuickSort.sort(x, a, a + s, paired);
        }
        if ((s = pd - pc) > 1) {
            QuickSort.sort(x, pn - s, pn, paired);
        }
    }

    public static void sort(float[] x, int start, int end, Collection<List<?>> paired) {
        int pc;
        int pa;
        int a = start;
        int n = end - start;
        if (n < 7) {
            for (int i = a; i < end; ++i) {
                for (int j = i; j > a && x[j - 1] > x[j]; --j) {
                    QuickSort.swap(x, j, j - 1, paired);
                }
            }
            return;
        }
        int pm = a + n / 2;
        if (n > 7) {
            int pl = a;
            int pn = a + n - 1;
            if (n > 40) {
                int s = n / 8;
                pl = QuickSort.med3(x, pl, pl + s, pl + 2 * s);
                pm = QuickSort.med3(x, pm - s, pm, pm + s);
                pn = QuickSort.med3(x, pn - 2 * s, pn - s, pn);
            }
            pm = QuickSort.med3(x, pl, pm, pn);
        }
        double pivotValue = x[pm];
        int pb = pa = a;
        int pd = pc = end - 1;
        while (true) {
            if (pb <= pc && (double)x[pb] <= pivotValue) {
                if ((double)x[pb] == pivotValue) {
                    QuickSort.swap(x, pa++, pb, paired);
                }
                ++pb;
                continue;
            }
            while (pc >= pb && (double)x[pc] >= pivotValue) {
                if ((double)x[pc] == pivotValue) {
                    QuickSort.swap(x, pc, pd--, paired);
                }
                --pc;
            }
            if (pb > pc) break;
            QuickSort.swap(x, pb++, pc--, paired);
        }
        int pn = end;
        int s = Math.min(pa - a, pb - pa);
        QuickSort.vecswap(x, a, pb - s, s, paired);
        s = Math.min(pd - pc, pn - pd - 1);
        QuickSort.vecswap(x, pb, pn - s, s, paired);
        s = pb - pa;
        if (s > 1) {
            QuickSort.sort(x, a, a + s, paired);
        }
        if ((s = pd - pc) > 1) {
            QuickSort.sort(x, pn - s, pn, paired);
        }
    }
}

