/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class IntPriorityQueue
extends AbstractQueue<Integer>
implements Serializable {
    private static final long serialVersionUID = -310756323843109562L;
    public static final Comparator<Integer> naturalComparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }
    };
    private int[] heap;
    private int size;
    private Comparator<Integer> comparator;
    private final HashMap<Integer, Integer> valueIndexMap;
    private int[] valueIndexStore;
    private final Mode fastValueRemove;

    public IntPriorityQueue() {
        this(8, naturalComparator);
    }

    public IntPriorityQueue(int initialSize, Comparator<Integer> comparator) {
        this(initialSize, comparator, Mode.STANDARD);
    }

    public IntPriorityQueue(int initialSize, Mode fastValueRemove) {
        this(initialSize, naturalComparator, fastValueRemove);
    }

    public IntPriorityQueue(int initialSize, Comparator<Integer> comparator, Mode fastValueRemove) {
        this.heap = new int[initialSize];
        this.comparator = comparator;
        this.size = 0;
        this.fastValueRemove = fastValueRemove;
        this.valueIndexStore = null;
        if (fastValueRemove == Mode.HASH) {
            this.valueIndexMap = new HashMap(initialSize);
        } else if (fastValueRemove == Mode.BOUNDED) {
            this.valueIndexStore = new int[initialSize];
            Arrays.fill(this.valueIndexStore, -1);
            this.valueIndexMap = null;
        } else {
            this.valueIndexMap = null;
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int pos;
            boolean canRemove;
            {
                this.pos = IntPriorityQueue.this.size - 1;
                this.canRemove = false;
            }

            @Override
            public boolean hasNext() {
                return this.pos >= 0;
            }

            @Override
            public Integer next() {
                this.canRemove = true;
                return IntPriorityQueue.this.heap[this.pos--];
            }

            @Override
            public void remove() {
                if (!this.canRemove) {
                    throw new IllegalStateException("An element can not currently be removed");
                }
                this.canRemove = false;
                IntPriorityQueue.this.removeHeapNode(this.pos + 1);
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean offer(Integer e) {
        if (e == null) {
            return false;
        }
        return this.offer((int)e);
    }

    @Override
    public boolean offer(int e) {
        int i = this.size++;
        if (this.heap.length < this.size) {
            this.heap = Arrays.copyOf(this.heap, this.heap.length * 2);
        }
        this.heap[i] = e;
        if (this.fastValueRemove == Mode.HASH) {
            this.valueIndexMap.put(e, i);
        } else if (this.fastValueRemove == Mode.BOUNDED) {
            if (e >= 0) {
                this.indexArrayStore(e, i);
            } else {
                this.heap[i] = 0;
                --this.size;
                return false;
            }
        }
        this.heapifyUp(i);
        return true;
    }

    private void indexArrayStore(int e, int i) {
        if (this.valueIndexStore.length < e) {
            int oldLength = this.valueIndexStore.length;
            this.valueIndexStore = Arrays.copyOf(this.valueIndexStore, e + 2);
            Arrays.fill(this.valueIndexStore, oldLength, this.valueIndexStore.length, -1);
        }
        this.valueIndexStore[e] = i;
    }

    private int getRightMostChild(int i) {
        int rightMostChild = i;
        while (this.rightChild(rightMostChild) < this.size) {
            rightMostChild = this.rightChild(rightMostChild);
        }
        while (this.leftChild(rightMostChild) < this.size) {
            rightMostChild = this.leftChild(rightMostChild);
        }
        return rightMostChild;
    }

    private int cmp(int i, int j) {
        return this.comparator.compare(this.heap[i], this.heap[j]);
    }

    private void heapDown(int i) {
        int iL = this.leftChild(i);
        int iR = this.rightChild(i);
        while (this.childIsSmallerAndValid(i, iL) || this.childIsSmallerAndValid(i, iR)) {
            if (iR < this.size && this.cmp(iL, iR) > 0) {
                this.swapHeapValues(i, iR);
                i = iR;
            } else {
                this.swapHeapValues(i, iL);
                i = iL;
            }
            iL = this.leftChild(i);
            iR = this.rightChild(i);
        }
    }

    private void heapifyUp(int i) {
        int iP = this.parent(i);
        while (i != 0 && this.cmp(i, iP) < 0) {
            this.swapHeapValues(iP, i);
            i = iP;
            iP = this.parent(i);
        }
    }

    private void swapHeapValues(int i, int j) {
        if (this.fastValueRemove == Mode.HASH) {
            this.valueIndexMap.put(this.heap[i], j);
            this.valueIndexMap.put(this.heap[j], i);
        } else if (this.fastValueRemove == Mode.BOUNDED) {
            this.valueIndexStore[this.heap[i]] = j;
            this.valueIndexStore[this.heap[j]] = i;
        }
        int tmp = this.heap[i];
        this.heap[i] = this.heap[j];
        this.heap[j] = tmp;
    }

    private int parent(int i) {
        return (i - 1) / 2;
    }

    private int leftChild(int i) {
        return 2 * i + 1;
    }

    protected int removeHeapNode(int i) {
        int val = this.heap[i];
        int rightMost = --this.size;
        this.heap[i] = this.heap[rightMost];
        this.heap[rightMost] = 0;
        if (this.fastValueRemove == Mode.HASH) {
            this.valueIndexMap.remove(val);
            if (this.size != 0) {
                this.valueIndexMap.put(this.heap[i], i);
            }
        } else if (this.fastValueRemove == Mode.BOUNDED) {
            this.valueIndexStore[val] = -1;
        }
        this.heapDown(i);
        return val;
    }

    private int rightChild(int i) {
        return 2 * i + 2;
    }

    private boolean childIsSmallerAndValid(int i, int child) {
        return child < this.size && this.cmp(i, child) > 0;
    }

    @Override
    public Integer poll() {
        if (this.isEmpty()) {
            return null;
        }
        return this.removeHeapNode(0);
    }

    @Override
    public Integer peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.heap[0];
    }

    @Override
    public boolean contains(Object o) {
        if (this.fastValueRemove == Mode.HASH) {
            return this.valueIndexMap.containsKey(o);
        }
        if (this.fastValueRemove == Mode.BOUNDED) {
            if (o instanceof Integer) {
                int val = (Integer)o;
                return val >= 0 && this.valueIndexStore[val] >= 0;
            }
            return false;
        }
        return super.contains(o);
    }

    @Override
    public void clear() {
        Arrays.fill(this.heap, 0, this.size, 0);
        this.size = 0;
        if (this.fastValueRemove == Mode.HASH) {
            this.valueIndexMap.clear();
        } else if (this.fastValueRemove == Mode.BOUNDED) {
            Arrays.fill(this.valueIndexStore, -1);
        }
    }

    @Override
    public boolean remove(Object o) {
        if (this.fastValueRemove == Mode.HASH) {
            Integer index = this.valueIndexMap.get(o);
            if (index == null) {
                return false;
            }
            this.removeHeapNode(index);
            return true;
        }
        if (this.fastValueRemove == Mode.BOUNDED) {
            if (o instanceof Integer) {
                int val = (Integer)o;
                if (val < 0 || val >= this.valueIndexStore.length) {
                    return false;
                }
                int index = this.valueIndexStore[val];
                if (index == -1) {
                    return false;
                }
                this.removeHeapNode(index);
                return true;
            }
            return false;
        }
        return super.remove(o);
    }

    public static enum Mode {
        STANDARD,
        HASH,
        BOUNDED;

    }
}

