/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jsat.utils.DoubleList;
import jsat.utils.IntList;
import jsat.utils.ListUtils;

public class IndexTable
implements Serializable {
    private static final long serialVersionUID = -1917765351445664286L;
    private static final Comparator defaultComp = (o1, o2) -> {
        Comparable co1 = (Comparable)o1;
        Comparable co2 = (Comparable)o2;
        return co1.compareTo(co2);
    };
    private IntList index;
    private int prevSize;

    public static <T> Comparator<T> getReverse(Comparator<T> cmp) {
        return (o1, o2) -> -cmp.compare(o1, o2);
    }

    public IndexTable(int size) {
        this.index = new IntList(size);
        ListUtils.addRange(this.index, 0, size, 1);
    }

    public IndexTable(double[] array) {
        this(DoubleList.unmodifiableView(array, array.length));
    }

    public <T extends Comparable<T>> IndexTable(T[] array) {
        this.index = new IntList(array.length);
        ListUtils.addRange(this.index, 0, array.length, 1);
        Collections.sort(this.index, new IndexViewCompG(this, array));
    }

    public <T extends Comparable<T>> IndexTable(List<T> list) {
        this(list, defaultComp);
    }

    public <T> IndexTable(List<T> list, Comparator<T> comparator) {
        this.index = new IntList(list.size());
        ListUtils.addRange(this.index, 0, list.size(), 1);
        this.sort(list, comparator);
    }

    public void reset() {
        for (int i = 0; i < this.index.size(); ++i) {
            this.index.set(i, i);
        }
    }

    public void reverse() {
        Collections.reverse(this.index);
    }

    public void sort(double[] array) {
        this.sort(DoubleList.unmodifiableView(array, array.length));
    }

    public void sortR(double[] array) {
        this.sortR(DoubleList.unmodifiableView(array, array.length));
    }

    public <T extends Comparable<T>> void sort(List<T> list) {
        this.sort(list, defaultComp);
    }

    public <T extends Comparable<T>> void sortR(List<T> list) {
        this.sort(list, IndexTable.getReverse(defaultComp));
    }

    public <T> void sort(List<T> list, Comparator<T> cmp) {
        if (this.index.size() < list.size()) {
            for (int i = this.index.size(); i < list.size(); ++i) {
                this.index.add(i);
            }
        }
        if (list.size() == this.index.size()) {
            Collections.sort(this.index, new IndexViewCompList<T>(list, cmp));
        } else {
            Collections.sort(this.index);
            Collections.sort(this.index.subList(0, list.size()), new IndexViewCompList<T>(list, cmp));
        }
        this.prevSize = list.size();
    }

    public void swap(int i, int j) {
        Collections.swap(this.index, i, j);
    }

    public int index(int i) {
        if (i >= this.prevSize || i < 0) {
            throw new IndexOutOfBoundsException("The size of the previously sorted array/list is " + this.prevSize + " so index " + i + " is not valid");
        }
        return this.index.get(i);
    }

    public int length() {
        return this.prevSize;
    }

    public void apply(double[] target) {
        this.apply(DoubleList.view(target, target.length), new DoubleList(target.length));
    }

    public void apply(List target) {
        this.apply(target, new ArrayList(target.size()));
    }

    public void apply(List target, List tmp) {
        int i;
        if (target.size() != this.length()) {
            throw new RuntimeException("target array does not have the same length as the index table");
        }
        for (i = 0; i < target.size(); ++i) {
            if (i >= tmp.size()) {
                tmp.add(target.get(i));
                continue;
            }
            tmp.set(i, target.get(i));
        }
        for (i = 0; i < target.size(); ++i) {
            target.set(i, tmp.get(this.index(i)));
        }
    }

    private class IndexViewCompList<T>
    implements Comparator<Integer> {
        final List<T> base;
        final Comparator<T> comparator;

        public IndexViewCompList(List<T> base, Comparator<T> comparator) {
            this.base = base;
            this.comparator = comparator;
        }

        @Override
        public int compare(Integer t, Integer t1) {
            return this.comparator.compare(this.base.get(t), this.base.get(t1));
        }
    }

    private static class IndexViewCompG<T extends Comparable<T>>
    implements Comparator<Integer> {
        T[] base;
        final /* synthetic */ IndexTable this$0;

        public IndexViewCompG(T[] base) {
            this.this$0 = var1_1;
            this.base = base;
        }

        @Override
        public int compare(Integer t, Integer t1) {
            return this.base[t].compareTo(this.base[t1]);
        }
    }
}

