/*
 * Decompiled with CFR 0.152.
 */
package jsat.text.stemming;

import java.util.LinkedHashMap;
import java.util.Map;
import jsat.text.stemming.Stemmer;

public class PorterStemmer
extends Stemmer {
    private static final long serialVersionUID = -3809291457988435043L;
    static final Map<String, String> step2_endings = new LinkedHashMap<String, String>();
    static final Map<String, String> step3_endings;
    static final Map<String, String> step4_endings;

    @Override
    public String stem(String s) {
        int lp;
        String tmp;
        if (s.endsWith("sses")) {
            s = s.replaceAll("sses$", "ss");
        } else if (s.endsWith("ies")) {
            s = s.replaceAll("ies$", "i");
        } else if (!s.endsWith("ss") && s.endsWith("s")) {
            s = s.substring(0, s.length() - 1);
        }
        boolean step1b_specialCase = false;
        if (s.endsWith("eed")) {
            tmp = s.replaceAll("eed$", "ee");
            if (PorterStemmer.measure(tmp) > 0) {
                s = tmp;
            }
        } else if (s.endsWith("ed")) {
            tmp = s.replaceAll("ed$", "");
            if (PorterStemmer.containsVowel(tmp)) {
                s = tmp;
                step1b_specialCase = true;
            }
        } else if (s.endsWith("ing") && PorterStemmer.containsVowel(tmp = s.replaceAll("ing$", ""))) {
            s = tmp;
            step1b_specialCase = true;
        }
        if (step1b_specialCase) {
            if (s.endsWith("at")) {
                s = s.concat("e");
            } else if (s.endsWith("bl")) {
                s = s.concat("e");
            } else if (s.endsWith("iz")) {
                s = s.concat("e");
            } else if (PorterStemmer.doubleConstant(s, 'l', 's', 'z')) {
                s = s.substring(0, s.length() - 1);
            } else if (PorterStemmer.oRule(s) && PorterStemmer.measure(s) == 1) {
                s = s.concat("e");
            }
        }
        if (s.endsWith("y") && PorterStemmer.containsVowel(s.substring(0, s.length() - 1))) {
            s = s.substring(0, s.length() - 1).concat("i");
        }
        for (Map.Entry<String, String> entry : step2_endings.entrySet()) {
            if (!s.endsWith(entry.getKey()) || PorterStemmer.measure(tmp = s.replaceAll(entry.getKey() + "$", entry.getValue())) <= 0) continue;
            s = tmp;
            break;
        }
        for (Map.Entry<String, String> entry : step3_endings.entrySet()) {
            if (!s.endsWith(entry.getKey()) || PorterStemmer.measure(tmp = s.replaceAll(entry.getKey() + "$", entry.getValue())) <= 0) continue;
            s = tmp;
            break;
        }
        for (Map.Entry<String, String> entry : step4_endings.entrySet()) {
            if (!s.endsWith(entry.getKey()) || s.endsWith("ion") && (s.length() < 4 || s.charAt(s.length() - 4) != 's' && s.charAt(s.length() - 4) != 't') || PorterStemmer.measure(tmp = s.replaceAll(entry.getKey() + "$", entry.getValue())) <= 1) continue;
            s = tmp;
            break;
        }
        if (s.endsWith("e")) {
            tmp = s.substring(0, s.length() - 1);
            if (PorterStemmer.measure(tmp) > 1) {
                s = tmp;
            } else if (PorterStemmer.measure(tmp) == 1 && !PorterStemmer.oRule(tmp)) {
                s = tmp;
            }
        }
        if ((lp = s.length() - 1) < 1) {
            return s;
        }
        if (s.charAt(lp) == s.charAt(lp - 1) && s.charAt(lp) == 'l' && PorterStemmer.measure(tmp = s.substring(0, s.length() - 1)) > 1) {
            s = tmp;
        }
        return s;
    }

    private static int measure(String s) {
        return PorterStemmer.measure(s, 0, s.length());
    }

    private static int measure(String c, int start, int length) {
        int pos;
        int m = 0;
        for (pos = start; !PorterStemmer.isVowel(c, pos) && pos < length - start; ++pos) {
        }
        boolean vFollowedByC = false;
        do {
            vFollowedByC = false;
            while (PorterStemmer.isVowel(c, pos) && pos < length - start) {
                ++pos;
            }
            while (!PorterStemmer.isVowel(c, pos) && pos < length - start) {
                ++pos;
                vFollowedByC = true;
            }
            ++m;
        } while (pos < length - start && vFollowedByC);
        if (vFollowedByC) {
            return m;
        }
        return m - 1;
    }

    private static boolean isVowel(String s, int pos) {
        if (pos >= s.length()) {
            return false;
        }
        switch (s.charAt(pos)) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
            case 'y': {
                if (pos == s.length() - 1) {
                    return true;
                }
                return PorterStemmer.isVowel(s, pos + 1);
            }
        }
        return false;
    }

    private static boolean oRule(String s) {
        int pos = s.length() - 1;
        if (pos < 2) {
            return false;
        }
        if (!PorterStemmer.isVowel(s, pos) && PorterStemmer.isVowel(s, pos - 1) && !PorterStemmer.isVowel(s, pos - 2)) {
            switch (s.charAt(pos)) {
                case 'w': 
                case 'x': 
                case 'y': {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean containsVowel(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!PorterStemmer.isVowel(s, i)) continue;
            return true;
        }
        return false;
    }

    private static boolean doubleConstant(String s, char ... except) {
        if (s.length() <= 1) {
            return false;
        }
        char c = s.charAt(s.length() - 1);
        if (c == s.charAt(s.length() - 2)) {
            for (char e : except) {
                if (c != e) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        step2_endings.put("ational", "ate");
        step2_endings.put("tional", "tion");
        step2_endings.put("enci", "ence");
        step2_endings.put("anci", "ance");
        step2_endings.put("izer", "ize");
        step2_endings.put("abli", "able");
        step2_endings.put("alli", "al");
        step2_endings.put("entli", "ent");
        step2_endings.put("eli", "e");
        step2_endings.put("ousli", "ous");
        step2_endings.put("ization", "ize");
        step2_endings.put("ation", "ate");
        step2_endings.put("ator", "ate");
        step2_endings.put("alsim", "al");
        step2_endings.put("iveness", "ive");
        step2_endings.put("fulness", "ful");
        step2_endings.put("ousness", "ous");
        step2_endings.put("aliti", "al");
        step2_endings.put("iviti", "ive");
        step2_endings.put("biliti", "ble");
        step3_endings = new LinkedHashMap<String, String>();
        step3_endings.put("icate", "ic");
        step3_endings.put("ative", "");
        step3_endings.put("alize", "al");
        step3_endings.put("iciti", "ic");
        step3_endings.put("ical", "ic");
        step3_endings.put("ful", "");
        step3_endings.put("ness", "");
        step4_endings = new LinkedHashMap<String, String>();
        step4_endings.put("al", "");
        step4_endings.put("ance", "");
        step4_endings.put("ence", "");
        step4_endings.put("er", "");
        step4_endings.put("ic", "");
        step4_endings.put("able", "");
        step4_endings.put("ible", "");
        step4_endings.put("ant", "");
        step4_endings.put("ement", "");
        step4_endings.put("ment", "");
        step4_endings.put("ent", "");
        step4_endings.put("ion", "");
        step4_endings.put("ou", "");
        step4_endings.put("ism", "");
        step4_endings.put("ate", "");
        step4_endings.put("iti", "");
        step4_endings.put("ous", "");
        step4_endings.put("ive", "");
        step4_endings.put("ize", "");
    }
}

