/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.rootfinding;

import jsat.math.Function1D;
import jsat.math.rootfinding.RootFinder;

public class Zeroin
implements RootFinder {
    private static final long serialVersionUID = -8359510619103768778L;

    public static double root(double a, double b, Function1D f) {
        return Zeroin.root(1.0E-15, 1000, a, b, f);
    }

    public static double root(double eps, double a, double b, Function1D f) {
        return Zeroin.root(eps, 1000, a, b, f);
    }

    public static double root(double eps, int maxIterations, double a, double b, Function1D f) {
        double fs;
        double fa = f.f(a);
        double fb = f.f(b);
        if (Math.abs(fa - 0.0) < 2.0 * eps) {
            return a;
        }
        if (Math.abs(fb - 0.0) < 2.0 * eps) {
            return b;
        }
        if (fa * fb >= 0.0) {
            throw new ArithmeticException("The given search interval does not appear to contain the root ");
        }
        if (Math.abs(fa) < Math.abs(fb)) {
            double tmp = a;
            a = b;
            b = tmp;
            tmp = fa;
            fa = fb;
            fb = tmp;
        }
        double c = a;
        double fc = fa;
        boolean mflag = true;
        double d = 0.0;
        do {
            boolean cond5;
            double s = fa != fc && fb != fc ? a * fb * fc / ((fa - fb) * (fa - fc)) + b * fa * fc / ((fb - fa) * (fb - fc)) + c * fa * fb / ((fc - fa) * (fc - fb)) : b - fb * (b - a) / (fb - fa);
            boolean cond1 = (s - (3.0 * a + b) / 4.0) * (s - b) >= 0.0;
            boolean cond2 = mflag && Math.abs(s - b) >= Math.abs(b - c) / 2.0;
            boolean cond3 = !mflag && Math.abs(s - b) >= Math.abs(c - d) / 2.0;
            boolean cond4 = mflag && Math.abs(b - c) < 2.0 * eps;
            boolean bl = cond5 = !mflag && Math.abs(c - d) < 2.0 * eps;
            if (cond1 || cond2 || cond3 || cond4 || cond5) {
                s = (a + b) / 2.0;
                mflag = true;
            } else {
                mflag = false;
            }
            fs = f.f(s);
            d = c;
            c = b;
            if (fa * fs < 0.0) {
                b = s;
                fb = fs;
            } else {
                a = s;
                fa = fs;
            }
            if (!(Math.abs(fa) < Math.abs(fb))) continue;
            double tmp = a;
            a = b;
            b = tmp;
            tmp = fa;
            fa = fb;
            fb = tmp;
        } while (fb != 0.0 && fs != 0.0 && Math.abs(b - a) > 2.0 * eps && maxIterations-- > 0);
        return b;
    }

    @Override
    public double root(double eps, int maxIterations, double[] initialGuesses, Function1D f) {
        return Zeroin.root(eps, maxIterations, initialGuesses[0], initialGuesses[1], f);
    }

    @Override
    public int guessesNeeded() {
        return 2;
    }
}

