/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.rootfinding;

import jsat.math.Function1D;
import jsat.math.rootfinding.RootFinder;

public class RiddersMethod
implements RootFinder {
    private static final long serialVersionUID = 8154909945080099018L;

    public static double root(double a, double b, Function1D f) {
        return RiddersMethod.root(1.0E-15, a, b, f);
    }

    public static double root(double eps, double a, double b, Function1D f) {
        return RiddersMethod.root(eps, 1000, a, b, f);
    }

    public static double root(double eps, int maxIterations, double a, double b, Function1D f) {
        double x1 = a;
        double x2 = b;
        double fx1 = f.f(x1);
        double fx2 = f.f(x2);
        double halfEps = eps * 0.5;
        if (fx1 * fx2 >= 0.0) {
            throw new ArithmeticException("The given interval does not appear to bracket the root");
        }
        double dif = 1.0;
        while (Math.abs(x1 - x2) > eps && maxIterations-- > 0) {
            double x4;
            double fx4;
            double x3 = (x1 + x2) * 0.5;
            double fx3 = f.f(x3);
            if (fx3 * (fx4 = f.f(x4 = x3 + (x3 - x1) * Math.signum(fx1 - fx2) * fx3 / Math.sqrt(fx3 * fx3 - fx1 * fx2))) < 0.0) {
                x1 = x3;
                fx1 = fx3;
                x2 = x4;
                fx2 = fx4;
                continue;
            }
            if (fx1 * fx4 < 0.0) {
                dif = Math.abs(x4 - x2);
                if (dif <= halfEps) {
                    return x4;
                }
                x2 = x4;
                fx2 = fx4;
                continue;
            }
            dif = Math.abs(x4 - x1);
            if (dif <= halfEps) {
                return x4;
            }
            x1 = x4;
            fx1 = fx4;
        }
        return x2;
    }

    @Override
    public double root(double eps, int maxIterations, double[] initialGuesses, Function1D f) {
        return RiddersMethod.root(eps, maxIterations, initialGuesses[0], initialGuesses[1], f);
    }

    @Override
    public int guessesNeeded() {
        return 2;
    }
}

