/*
 * Decompiled with CFR 0.152.
 */
package jsat.math;

import java.io.Serializable;

public class Complex
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2219274170047061708L;
    private double real;
    private double imag;

    public static Complex I() {
        return new Complex(0.0, 1.0);
    }

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public double getReal() {
        return this.real;
    }

    public void setReal(double r) {
        this.real = r;
    }

    public void setImag(double imag) {
        this.imag = imag;
    }

    public double getImag() {
        return this.imag;
    }

    public void mutableAdd(double r, double i) {
        this.real += r;
        this.imag += i;
    }

    public void mutableAdd(Complex c) {
        this.mutableAdd(c.real, c.imag);
    }

    public Complex add(Complex c) {
        Complex ret = new Complex(this.real, this.imag);
        ret.mutableAdd(c);
        return ret;
    }

    public void mutableSubtract(double r, double i) {
        this.mutableAdd(-r, -i);
    }

    public void mutableSubtract(Complex c) {
        this.mutableSubtract(c.real, c.imag);
    }

    public Complex subtract(Complex c) {
        Complex ret = new Complex(this.real, this.imag);
        ret.mutableSubtract(c);
        return ret;
    }

    public static void cMul(double a, double b, double c, double d, double[] results) {
        results[0] = a * c - b * d;
        results[1] = b * c + a * d;
    }

    public void mutableMultiply(double c, double d) {
        double newR = this.real * c - this.imag * d;
        double newI = this.imag * c + this.real * d;
        this.real = newR;
        this.imag = newI;
    }

    public void mutableMultiply(Complex c) {
        this.mutableMultiply(c.real, c.imag);
    }

    public Complex multiply(Complex c) {
        Complex ret = new Complex(this.real, this.imag);
        ret.mutableMultiply(c);
        return ret;
    }

    public static void cDiv(double a, double b, double c, double d, double[] results) {
        long bb;
        int hb;
        long aa = Double.doubleToRawLongBits(a);
        int ha = (int)(aa >> 32 & Integer.MAX_VALUE);
        int hz = ha > (hb = (int)((bb = Double.doubleToRawLongBits(b)) >> 32 & Integer.MAX_VALUE)) ? ha : hb;
        long cc = Double.doubleToRawLongBits(c);
        long dd = Double.doubleToRawLongBits(d);
        int hc = (int)(cc >> 32 & Integer.MAX_VALUE);
        int hd = (int)(dd >> 32 & Integer.MAX_VALUE);
        int hw = hc > hd ? hc : hd;
        int hs = hz < 0x7200000 && hw >= 847249408 && hw < 1192230912 ? (1192230912 - hw >> 1 & 0xFFF00000) + 0x3FF00000 : (hw >> 2) - hw + 1876426751 & 0xFFF00000;
        long ss = (long)hs << 32;
        double ssd = Double.longBitsToDouble(ss);
        double t = 1.0 / ((c *= ssd) * c + (d *= ssd) * d);
        results[0] = (a * (c *= ssd) + b * (d *= ssd)) * t;
        results[1] = (b * c - a * d) * t;
    }

    public void mutableDivide(double c, double d) {
        double[] r = new double[2];
        Complex.cDiv(this.real, this.imag, c, d, r);
        this.real = r[0];
        this.imag = r[1];
    }

    public void mutableDivide(Complex c) {
        this.mutableDivide(c.real, c.imag);
    }

    public Complex divide(Complex c) {
        Complex ret = new Complex(this.real, this.imag);
        ret.mutableDivide(c);
        return ret;
    }

    public double getMagnitude() {
        return Math.hypot(this.real, this.imag);
    }

    public double getArg() {
        return Math.atan2(this.imag, this.real);
    }

    public void mutateConjugate() {
        this.imag = -this.imag;
    }

    public Complex getConjugate() {
        return new Complex(this.real, -this.imag);
    }

    public String toString() {
        if (this.imag == 0.0) {
            return Double.toString(this.real);
        }
        if (this.real == 0.0) {
            return this.imag + "i";
        }
        return "(" + this.real + " + " + this.imag + "i)";
    }

    protected Complex clone() {
        return new Complex(this.real, this.imag);
    }

    public boolean equals(Object obj) {
        return this.equals(obj, 0.0);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.real) ^ Double.doubleToLongBits(this.real) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.imag) ^ Double.doubleToLongBits(this.imag) >>> 32);
        return hash;
    }

    public boolean equals(Object obj, double eps) {
        if (obj instanceof Complex) {
            Complex other = (Complex)obj;
            if (Math.abs(this.real - other.real) > eps) {
                return false;
            }
            return !(Math.abs(this.imag - other.imag) > eps);
        }
        return false;
    }
}

