/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.IndexDistPair;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.utils.BoundedSortedList;
import jsat.utils.DoubleList;
import jsat.utils.IndexTable;
import jsat.utils.IntList;
import jsat.utils.ListUtils;
import jsat.utils.concurrent.ParallelUtils;

public class RandomBallCoverOneShot<V extends Vec>
implements VectorCollection<V> {
    private static final long serialVersionUID = -2562499883847452797L;
    private DistanceMetric dm;
    private List<List<Integer>> ownedVecs;
    private List<Integer> R;
    private List<V> allVecs;
    private List<Double> distCache;
    private int s;
    double[] repRadius;

    public RandomBallCoverOneShot(List<V> vecs, DistanceMetric dm, int s, boolean parallel) {
        this.s = s;
        this.build(parallel, vecs, dm);
    }

    public RandomBallCoverOneShot(List<V> vecs, DistanceMetric dm, boolean parallel) {
        this(vecs, dm, (int)Math.sqrt(vecs.size()), parallel);
    }

    public RandomBallCoverOneShot(List<V> vecs, DistanceMetric dm, int s) {
        this(vecs, dm, s, false);
    }

    public RandomBallCoverOneShot(List<V> vecs, DistanceMetric dm) {
        this(vecs, dm, (int)Math.sqrt(vecs.size()));
    }

    public RandomBallCoverOneShot() {
        this.dm = new EuclideanDistance();
        this.s = -1;
    }

    private RandomBallCoverOneShot(RandomBallCoverOneShot<V> other) {
        this.dm = other.dm.clone();
        this.ownedVecs = new ArrayList<List<Integer>>(other.ownedVecs.size());
        for (int i = 0; i < other.ownedVecs.size(); ++i) {
            this.ownedVecs.add(new IntList((Collection<Integer>)other.ownedVecs.get(i)));
        }
        this.R = new IntList(other.R);
        this.repRadius = Arrays.copyOf(other.repRadius, other.repRadius.length);
        this.s = other.s;
        if (other.distCache != null) {
            this.distCache = new DoubleList(other.distCache);
        }
        if (other.allVecs != null) {
            this.allVecs = new ArrayList<V>(other.allVecs);
        }
    }

    @Override
    public void build(boolean parallel, List<V> collection, DistanceMetric dm) {
        this.allVecs = new ArrayList<V>(collection);
        this.distCache = dm.getAccelerationCache(collection, parallel);
        IntList allIndices = new IntList(this.allVecs.size());
        ListUtils.addRange(allIndices, 0, this.allVecs.size(), 1);
        if (this.s < 0) {
            this.s = (int)Math.sqrt(this.allVecs.size());
        }
        this.setUp(allIndices, parallel);
    }

    private void setUp(List<Integer> allIndices, boolean parallel) {
        int repCount = (int)Math.max(1.0, Math.sqrt(allIndices.size()));
        Collections.shuffle(allIndices);
        this.R = allIndices.subList(0, repCount);
        this.repRadius = new double[this.R.size()];
        List<Integer> allRemainingVecs = allIndices.subList(repCount, allIndices.size());
        this.ownedVecs = new ArrayList<List<Integer>>(repCount);
        for (int i2 = 0; i2 < repCount; ++i2) {
            this.ownedVecs.add(new IntList(this.s));
        }
        ParallelUtils.run(parallel, this.R.size(), i -> {
            int Ri = this.R.get(i);
            List<Integer> ROwned = this.ownedVecs.get(i);
            BoundedSortedList<IndexDistPair> nearest = new BoundedSortedList<IndexDistPair>(this.s);
            Iterator iterator = allRemainingVecs.iterator();
            while (iterator.hasNext()) {
                int v = (Integer)iterator.next();
                nearest.add(new IndexDistPair(v, this.dm.dist(v, Ri, this.allVecs, this.distCache)));
            }
            for (IndexDistPair pmv : nearest) {
                ROwned.add(pmv.getIndex());
            }
        });
    }

    @Override
    public List<Double> getAccelerationCache() {
        return this.distCache;
    }

    @Override
    public void search(Vec query, double range, List<Integer> neighbors, List<Double> distances) {
        double tmp;
        neighbors.clear();
        distances.clear();
        List<Double> qi = this.dm.getQueryInfo(query);
        double bestDist = Double.POSITIVE_INFINITY;
        int bestRep = 0;
        for (int i = 0; i < this.R.size(); ++i) {
            double d;
            tmp = this.dm.dist(this.R.get(i), query, qi, this.allVecs, this.distCache);
            if (d < bestDist) {
                bestRep = i;
                bestDist = tmp;
            }
            if (!(tmp <= range)) continue;
            neighbors.add(this.R.get(i));
            distances.add(tmp);
        }
        for (int v : this.ownedVecs.get(bestRep)) {
            double d;
            tmp = this.dm.dist(v, query, qi, this.allVecs, this.distCache);
            if (!(d <= range)) continue;
            neighbors.add(v);
            distances.add(tmp);
        }
        IndexTable it = new IndexTable(distances);
        it.apply(neighbors);
        it.apply(distances);
    }

    @Override
    public void search(Vec query, int numNeighbors, List<Integer> neighbors, List<Double> distances) {
        neighbors.clear();
        distances.clear();
        BoundedSortedList<IndexDistPair> knn = new BoundedSortedList<IndexDistPair>(numNeighbors);
        List<Double> qi = this.dm.getQueryInfo(query);
        double bestDist = Double.POSITIVE_INFINITY;
        int bestRep = 0;
        for (int i = 0; i < this.R.size(); ++i) {
            double d;
            double tmp = this.dm.dist(this.R.get(i), query, qi, this.allVecs, this.distCache);
            if (!(d < bestDist)) continue;
            bestRep = i;
            bestDist = tmp;
        }
        knn.add(new IndexDistPair(this.R.get(bestRep), bestDist));
        for (int v : this.ownedVecs.get(bestRep)) {
            knn.add(new IndexDistPair(v, this.dm.dist(v, query, qi, this.allVecs, this.distCache)));
        }
        for (IndexDistPair v : knn) {
            neighbors.add(v.getIndex());
            distances.add(v.getDist());
        }
    }

    @Override
    public int size() {
        return this.R.size() * this.s;
    }

    @Override
    public V get(int indx) {
        return (V)((Vec)this.allVecs.get(indx));
    }

    @Override
    public RandomBallCoverOneShot<V> clone() {
        return new RandomBallCoverOneShot<V>(this);
    }

    @Override
    public void setDistanceMetric(DistanceMetric dm) {
        this.dm = dm;
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        return this.dm;
    }
}

