/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.distancemetrics;

import java.util.List;
import java.util.concurrent.ExecutorService;
import jsat.DataSet;
import jsat.classifiers.ClassificationDataSet;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.regression.RegressionDataSet;

public abstract class TrainableDistanceMetric
implements DistanceMetric {
    private static final long serialVersionUID = 6356276953152869105L;

    public <V extends Vec> void train(List<V> dataSet) {
        this.train(dataSet, false);
    }

    public abstract <V extends Vec> void train(List<V> var1, boolean var2);

    public void train(DataSet dataSet) {
        this.train(dataSet, false);
    }

    public abstract void train(DataSet var1, boolean var2);

    public void train(ClassificationDataSet dataSet) {
        this.train(dataSet, false);
    }

    public abstract void train(ClassificationDataSet var1, boolean var2);

    public abstract boolean supportsClassificationTraining();

    public abstract void train(RegressionDataSet var1);

    public abstract void train(RegressionDataSet var1, boolean var2);

    public abstract boolean supportsRegressionTraining();

    public abstract boolean needsTraining();

    @Override
    public abstract TrainableDistanceMetric clone();

    public static void trainIfNeeded(DistanceMetric dm, DataSet dataset) {
        TrainableDistanceMetric.trainIfNeeded(dm, dataset, false);
    }

    public static void trainIfNeeded(DistanceMetric dm, DataSet dataset, boolean parallel) {
        if (!(dm instanceof TrainableDistanceMetric)) {
            return;
        }
        TrainableDistanceMetric tdm = (TrainableDistanceMetric)dm;
        if (!tdm.needsTraining()) {
            return;
        }
        if (dataset instanceof RegressionDataSet) {
            tdm.train((RegressionDataSet)dataset, parallel);
        } else if (dataset instanceof ClassificationDataSet) {
            tdm.train((ClassificationDataSet)dataset, parallel);
        } else {
            tdm.train(dataset, parallel);
        }
    }

    public static void trainIfNeeded(DistanceMetric dm, DataSet dataset, ExecutorService threadpool) {
        TrainableDistanceMetric.trainIfNeeded(dm, dataset);
    }

    public static <V extends Vec> void trainIfNeeded(DistanceMetric dm, List<V> dataset, ExecutorService threadpool) {
        TrainableDistanceMetric.trainIfNeeded(dm, dataset, false);
    }

    public static <V extends Vec> void trainIfNeeded(DistanceMetric dm, List<V> dataset) {
        TrainableDistanceMetric.trainIfNeeded(dm, dataset, false);
    }

    public static <V extends Vec> void trainIfNeeded(DistanceMetric dm, List<V> dataset, boolean parallel) {
        if (!(dm instanceof TrainableDistanceMetric)) {
            return;
        }
        TrainableDistanceMetric tdm = (TrainableDistanceMetric)dm;
        if (!tdm.needsTraining()) {
            return;
        }
        if (dataset instanceof RegressionDataSet) {
            tdm.train((RegressionDataSet)((Object)dataset), parallel);
        } else if (dataset instanceof ClassificationDataSet) {
            tdm.train((ClassificationDataSet)((Object)dataset), parallel);
        } else {
            tdm.train(dataset, parallel);
        }
    }
}

