/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.distancemetrics;

import java.util.Iterator;
import java.util.List;
import jsat.distributions.kernels.KernelTrick;
import jsat.linear.IndexValue;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;

public class JaccardDistance
implements DistanceMetric,
KernelTrick {
    private boolean weighted;

    public JaccardDistance(boolean weighted) {
        this.weighted = weighted;
    }

    public JaccardDistance() {
        this(true);
    }

    @Override
    public double dist(Vec a, Vec b) {
        return 1.0 - this.eval(a, b);
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isSubadditive() {
        return true;
    }

    @Override
    public boolean isIndiscemible() {
        return true;
    }

    @Override
    public double metricBound() {
        return 1.0;
    }

    @Override
    public boolean supportsAcceleration() {
        return false;
    }

    @Override
    public List<Double> getQueryInfo(Vec q) {
        return null;
    }

    @Override
    public double eval(Vec a, Vec b) {
        IndexValue finalVal;
        IndexValue b_val;
        double numer = 0.0;
        double denom = 0.0;
        Iterator<IndexValue> a_iter = a.getNonZeroIterator();
        Iterator<IndexValue> b_iter = b.getNonZeroIterator();
        IndexValue a_val = a_iter.hasNext() ? a_iter.next() : null;
        IndexValue indexValue = b_val = b_iter.hasNext() ? b_iter.next() : null;
        while (a_val != null && b_val != null) {
            if (this.weighted) {
                if (a_val.getIndex() == b_val.getIndex()) {
                    numer += Math.max(Math.min(a_val.getValue(), b_val.getValue()), 0.0);
                    denom += Math.max(Math.max(a_val.getValue(), b_val.getValue()), 0.0);
                    a_val = a_iter.hasNext() ? a_iter.next() : null;
                    b_val = b_iter.hasNext() ? b_iter.next() : null;
                    continue;
                }
                if (a_val.getIndex() < b_val.getIndex()) {
                    denom += Math.max(a_val.getValue(), 0.0);
                    a_val = a_iter.hasNext() ? a_iter.next() : null;
                    continue;
                }
                denom += Math.max(b_val.getValue(), 0.0);
                b_val = b_iter.hasNext() ? b_iter.next() : null;
                continue;
            }
            if (a_val.getIndex() == b_val.getIndex()) {
                numer += 1.0;
                denom += 1.0;
                a_val = a_iter.hasNext() ? a_iter.next() : null;
                b_val = b_iter.hasNext() ? b_iter.next() : null;
                continue;
            }
            if (a_val.getIndex() < b_val.getIndex()) {
                denom += 1.0;
                a_val = a_iter.hasNext() ? a_iter.next() : null;
                continue;
            }
            denom += 1.0;
            b_val = b_iter.hasNext() ? b_iter.next() : null;
        }
        Iterator<IndexValue> finalIter = a_val != null ? a_iter : b_iter;
        IndexValue indexValue2 = finalVal = a_val != null ? a_val : b_val;
        while (finalVal != null) {
            denom = this.weighted ? (denom += Math.max(finalVal.getValue(), 0.0)) : (denom += 1.0);
            finalVal = finalIter.hasNext() ? finalIter.next() : null;
        }
        return numer / denom;
    }

    @Override
    public JaccardDistance clone() {
        return new JaccardDistance(this.weighted);
    }

    @Override
    public void addToCache(Vec newVec, List<Double> cache) {
    }

    @Override
    public double eval(int a, Vec b, List<Double> qi, List<? extends Vec> vecs, List<Double> cache) {
        return this.eval(vecs.get(a), b);
    }

    @Override
    public double eval(int a, int b, List<? extends Vec> trainingSet, List<Double> cache) {
        return this.eval(trainingSet.get(a), trainingSet.get(b));
    }

    @Override
    public double evalSum(List<? extends Vec> finalSet, List<Double> cache, double[] alpha, Vec y, int start, int end) {
        return this.evalSum(finalSet, cache, alpha, y, this.getQueryInfo(y), start, end);
    }

    @Override
    public double evalSum(List<? extends Vec> finalSet, List<Double> cache, double[] alpha, Vec y, List<Double> qi, int start, int end) {
        double sum = 0.0;
        for (int i = start; i < end; ++i) {
            if (alpha[i] == 0.0) continue;
            sum += alpha[i] * this.eval(i, y, qi, finalSet, cache);
        }
        return sum;
    }

    @Override
    public boolean normalized() {
        return true;
    }

    @Override
    public List<Double> getAccelerationCache(List<? extends Vec> trainingSet) {
        return null;
    }
}

