/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.distancemetrics;

import jsat.linear.Vec;
import jsat.linear.distancemetrics.CosineDistance;
import jsat.linear.distancemetrics.DistanceMetric;

public class CosineDistanceNormalized
implements DistanceMetric {
    private static final long serialVersionUID = -4041803247001806577L;

    @Override
    public double dist(Vec a, Vec b) {
        return CosineDistance.cosineToDistance(Math.min(a.dot(b), 1.0));
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isSubadditive() {
        return true;
    }

    @Override
    public boolean isIndiscemible() {
        return true;
    }

    @Override
    public double metricBound() {
        return 1.0;
    }

    @Override
    public String toString() {
        return "Cosine Distance (Normalized)";
    }

    @Override
    public CosineDistanceNormalized clone() {
        return new CosineDistanceNormalized();
    }
}

