/*
 * Decompiled with CFR 0.152.
 */
package jsat.driftdetectors;

import jsat.driftdetectors.BaseDriftDetector;
import jsat.driftdetectors.UnhandledDriftException;

public class DDM<V>
extends BaseDriftDetector<V> {
    private static final long serialVersionUID = 3023405445609636195L;
    private int fails;
    private int minSamples = 30;
    private double p_min;
    private double s_min;
    private double warningThreshold;
    private double driftThreshold;

    public DDM() {
        this(2.0, 3.0);
    }

    public DDM(double warningThreshold, double driftThreshold) {
        this.setWarningThreshold(warningThreshold);
        this.setDriftThreshold(driftThreshold);
        this.driftHandled();
    }

    public DDM(DDM<V> toCopy) {
        super(toCopy);
        this.fails = toCopy.fails;
        this.warningThreshold = toCopy.warningThreshold;
        this.driftThreshold = toCopy.driftThreshold;
    }

    public double getSuccessRate() {
        return 1.0 - (double)this.fails / (double)this.time;
    }

    public boolean addSample(boolean trial, V obj) {
        if (this.drifting) {
            throw new UnhandledDriftException();
        }
        if (!trial) {
            ++this.fails;
        }
        ++this.time;
        if (this.time < this.minSamples) {
            return false;
        }
        double p_i = (double)this.fails / (double)this.time;
        double s_i = Math.sqrt(p_i * (1.0 - p_i) / (double)this.time);
        double ps = p_i + s_i;
        if (ps < this.p_min + this.s_min) {
            this.p_min = p_i;
            this.s_min = s_i;
        }
        if (ps > this.p_min + this.warningThreshold * this.s_min) {
            if (!this.warning) {
                this.warning = true;
                this.driftStart = this.time - 1;
            }
            this.addToHistory(obj);
            if (ps > this.p_min + this.driftThreshold * this.s_min) {
                this.warning = false;
                this.drifting = true;
            }
            return true;
        }
        this.warning = false;
        this.driftStart = -1;
        this.clearHistory();
        return false;
    }

    public void setWarningThreshold(double warningThreshold) {
        if (warningThreshold <= 0.0 || Double.isNaN(warningThreshold) || Double.isInfinite(warningThreshold)) {
            throw new IllegalArgumentException("warning threshold must be positive, not " + warningThreshold);
        }
        this.warningThreshold = warningThreshold;
    }

    public double getWarningThreshold() {
        return this.warningThreshold;
    }

    public void setDriftThreshold(double driftThreshold) {
        if (driftThreshold <= 0.0 || Double.isNaN(driftThreshold) || Double.isInfinite(driftThreshold)) {
            throw new IllegalArgumentException("Dritf threshold must be positive, not " + driftThreshold);
        }
        this.driftThreshold = driftThreshold;
    }

    public double getDriftThreshold() {
        return this.driftThreshold;
    }

    @Override
    public boolean addSample(double value, V obj) {
        return this.addSample(value == 0.0, obj);
    }

    @Override
    public void driftHandled() {
        super.driftHandled();
        this.fails = 0;
        this.s_min = Double.POSITIVE_INFINITY;
        this.p_min = Double.POSITIVE_INFINITY;
        this.time = 0;
        this.clearHistory();
    }

    @Override
    public DDM<V> clone() {
        return new DDM<V>(this);
    }
}

