/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.kernels;

import java.util.List;
import jsat.DataSet;
import jsat.distributions.Distribution;
import jsat.distributions.LogUniform;
import jsat.distributions.kernels.BaseL2Kernel;
import jsat.distributions.kernels.RBFKernel;
import jsat.linear.Vec;
import jsat.parameters.Parameterized;

public class PukKernel
extends BaseL2Kernel
implements Parameterized {
    private static final long serialVersionUID = 8727097671803148320L;
    private double sigma;
    private double omega;
    private double cnst;

    public PukKernel(double sigma, double omega) {
        this.setSigma(sigma);
        this.setOmega(omega);
    }

    public void setOmega(double omega) {
        if (omega <= 0.0 || Double.isNaN(omega) || Double.isInfinite(omega)) {
            throw new ArithmeticException("omega must be positive, not " + omega);
        }
        this.omega = omega;
        this.cnst = Math.sqrt(Math.pow(2.0, 1.0 / omega) - 1.0);
    }

    public double getOmega() {
        return this.omega;
    }

    public void setSigma(double sigma) {
        if (sigma <= 0.0 || Double.isNaN(sigma) || Double.isInfinite(sigma)) {
            throw new ArithmeticException("sigma must be positive, not " + sigma);
        }
        this.sigma = sigma;
    }

    public double getSigma() {
        return this.sigma;
    }

    @Override
    public double eval(Vec a, Vec b) {
        return this.getVal(a.pNormDist(2.0, b));
    }

    @Override
    public PukKernel clone() {
        return new PukKernel(this.sigma, this.omega);
    }

    @Override
    public double eval(int a, Vec b, List<Double> qi, List<? extends Vec> vecs, List<Double> cache) {
        return this.getVal(Math.sqrt(this.getSqrdNorm(a, b, qi, vecs, cache)));
    }

    @Override
    public double eval(int a, int b, List<? extends Vec> trainingSet, List<Double> cache) {
        return this.getVal(Math.sqrt(this.getSqrdNorm(b, b, trainingSet, cache)));
    }

    private double getVal(double pNormDist) {
        double tmp = 2.0 * pNormDist * this.cnst / this.sigma;
        return 1.0 / Math.pow(1.0 + tmp * tmp, this.omega);
    }

    public static Distribution guessOmega(DataSet d) {
        return new LogUniform(0.25, 50.0);
    }

    public static Distribution guessSigma(DataSet d) {
        return RBFKernel.guessSigma(d);
    }

    @Override
    public boolean normalized() {
        return true;
    }
}

