/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.kernels;

import java.util.Arrays;
import java.util.List;
import jsat.distributions.kernels.KernelTrick;
import jsat.linear.Vec;
import jsat.parameters.Parameter;

public class NormalizedKernel
implements KernelTrick {
    private KernelTrick k;

    public NormalizedKernel(KernelTrick source_kernel) {
        this.k = source_kernel;
    }

    @Override
    public NormalizedKernel clone() {
        return new NormalizedKernel(this.k.clone());
    }

    @Override
    public double eval(Vec a, Vec b) {
        double aa = this.k.eval(a, a);
        double bb = this.k.eval(b, b);
        if (aa == 0.0 || bb == 0.0) {
            return 0.0;
        }
        return this.k.eval(a, b) / Math.sqrt(aa * bb);
    }

    @Override
    public List<Parameter> getParameters() {
        return this.k.getParameters();
    }

    @Override
    public Parameter getParameter(String paramName) {
        return this.k.getParameter(paramName);
    }

    @Override
    public boolean supportsAcceleration() {
        return this.k.supportsAcceleration();
    }

    @Override
    public List<Double> getAccelerationCache(List<? extends Vec> trainingSet) {
        return this.k.getAccelerationCache(trainingSet);
    }

    @Override
    public List<Double> getQueryInfo(Vec q) {
        return this.k.getQueryInfo(q);
    }

    @Override
    public void addToCache(Vec newVec, List<Double> cache) {
        this.k.addToCache(newVec, cache);
    }

    @Override
    public double eval(int a, Vec b, List<Double> qi, List<? extends Vec> vecs, List<Double> cache) {
        double aa = this.k.eval(a, a, vecs, cache);
        double bb = this.k.eval(0, 0, Arrays.asList(b), qi);
        if (aa == 0.0 || bb == 0.0) {
            return 0.0;
        }
        return this.k.eval(a, b, qi, vecs, cache) / Math.sqrt(aa * bb);
    }

    @Override
    public double eval(int a, int b, List<? extends Vec> trainingSet, List<Double> cache) {
        double aa = this.k.eval(a, a, trainingSet, cache);
        double bb = this.k.eval(b, b, trainingSet, cache);
        if (aa == 0.0 || bb == 0.0) {
            return 0.0;
        }
        return this.k.eval(a, b, trainingSet, cache) / Math.sqrt(aa * bb);
    }

    @Override
    public double evalSum(List<? extends Vec> finalSet, List<Double> cache, double[] alpha, Vec y, int start, int end) {
        return this.evalSum(finalSet, cache, alpha, y, this.getQueryInfo(y), start, end);
    }

    @Override
    public double evalSum(List<? extends Vec> finalSet, List<Double> cache, double[] alpha, Vec y, List<Double> qi, int start, int end) {
        double sum = 0.0;
        for (int i = start; i < end; ++i) {
            sum += alpha[i] * this.eval(i, y, qi, finalSet, cache);
        }
        return sum;
    }

    @Override
    public boolean normalized() {
        return true;
    }
}

