/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.discrete;

import jsat.distributions.discrete.DiscreteDistribution;
import jsat.math.Function1D;
import jsat.math.SpecialMath;
import jsat.math.rootfinding.Bisection;

public class Zipf
extends DiscreteDistribution {
    private double cardinality;
    private double skew;
    private double denomCache;

    public Zipf(double cardinality, double skew) {
        this.setCardinality(cardinality);
        this.setSkew(skew);
    }

    public Zipf(double skew) {
        this(Double.POSITIVE_INFINITY, skew);
    }

    public Zipf() {
        this(1.0);
    }

    public Zipf(Zipf toCopy) {
        this.cardinality = toCopy.cardinality;
        this.skew = toCopy.skew;
        this.denomCache = toCopy.denomCache;
    }

    public void setCardinality(double cardinality) {
        if (cardinality < 0.0 || Double.isNaN(cardinality)) {
            throw new IllegalArgumentException("Cardinality must be a positive integer or infinity, not " + cardinality);
        }
        this.cardinality = Math.ceil(cardinality);
        this.fixCache();
    }

    public double getCardinality() {
        return this.cardinality;
    }

    public void setSkew(double skew) {
        if (skew <= 0.0 || Double.isNaN(skew) || Double.isInfinite(skew)) {
            throw new IllegalArgumentException("Skew must be a positive value, not " + skew);
        }
        this.skew = skew;
        this.fixCache();
    }

    private void fixCache() {
        this.denomCache = Double.isInfinite(this.cardinality) ? SpecialMath.zeta(1.0 + this.skew) : SpecialMath.harmonic(this.cardinality, 1.0 + this.skew);
    }

    public double getSkew() {
        return this.skew;
    }

    @Override
    public double pmf(int x) {
        if (x < 1) {
            return 0.0;
        }
        if (Double.isInfinite(this.cardinality)) {
            return Math.pow(x, -this.skew - 1.0) / this.denomCache;
        }
        if ((double)x > this.cardinality) {
            return 0.0;
        }
        return Math.pow(x, -this.skew - 1.0) / this.denomCache;
    }

    @Override
    public double cdf(int x) {
        if (x < 1) {
            return 0.0;
        }
        if ((double)x >= this.cardinality) {
            return 1.0;
        }
        if (Double.isInfinite(this.cardinality)) {
            return SpecialMath.harmonic(x, 1.0 + this.skew) / this.denomCache;
        }
        return SpecialMath.harmonic(x, 1.0 + this.skew) / this.denomCache;
    }

    @Override
    public double invCdf(double p) {
        return this.invCdfRootFinding(p, Math.max(1.0 / this.cardinality, 1.0E-14));
    }

    @Override
    protected double invCdfRootFinding(double p, double tol) {
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Value of p must be in the range [0,1], not " + p);
        }
        if (this.min() >= -2.147483648E9 && p <= this.cdf(this.min())) {
            return this.min();
        }
        if (this.max() < 2.147483647E9 && p > this.cdf(this.max() - 1.0)) {
            return this.max();
        }
        double cnst = p * this.denomCache;
        Function1D cdfInterpolated = x -> {
            double query = x;
            if (Double.isInfinite(this.cardinality)) {
                return SpecialMath.harmonic(x, 1.0 + this.skew) - cnst;
            }
            return SpecialMath.harmonic(x, 1.0 + this.skew) - cnst;
        };
        double a = this.min();
        double b = Double.isInfinite(this.max()) ? 2.0401094646499999E9 : this.max();
        double toRet = Bisection.root(tol, a, b, cdfInterpolated);
        return Math.min((double)Math.round(toRet), this.cardinality);
    }

    @Override
    public Zipf clone() {
        return new Zipf(this);
    }

    @Override
    public double mean() {
        if (Double.isInfinite(this.cardinality)) {
            if (this.skew <= 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return SpecialMath.zeta(this.skew) / this.denomCache;
        }
        return SpecialMath.harmonic(this.cardinality, this.skew) / this.denomCache;
    }

    @Override
    public double mode() {
        return 1.0;
    }

    @Override
    public double variance() {
        if (Double.isInfinite(this.cardinality)) {
            if (this.skew <= 2.0) {
                return Double.POSITIVE_INFINITY;
            }
            double zSkewP1 = this.denomCache;
            double zSkewM1 = SpecialMath.zeta(this.skew - 1.0);
            return zSkewM1 / zSkewP1 - Math.pow(SpecialMath.zeta(this.skew), 2.0) / (zSkewP1 * zSkewP1);
        }
        double hSkewP1 = SpecialMath.harmonic(this.cardinality, 1.0 + this.skew);
        return (-Math.pow(SpecialMath.harmonic(this.cardinality, this.skew), 2.0) + SpecialMath.harmonic(this.cardinality, this.skew - 1.0) * hSkewP1) / (hSkewP1 * hSkewP1);
    }

    @Override
    public double skewness() {
        if (Double.isInfinite(this.cardinality)) {
            if (this.skew <= 3.0) {
                return Double.POSITIVE_INFINITY;
            }
            double zSkew = SpecialMath.zeta(this.skew);
            double zSkewP1 = this.denomCache;
            double zSkewM1 = SpecialMath.zeta(this.skew - 1.0);
            return (2.0 * Math.pow(zSkew, 3.0) - 3.0 * zSkewM1 * zSkew * zSkewP1 + SpecialMath.zeta(-2.0 + this.skew) * Math.pow(zSkewP1, 2.0)) / Math.pow(-Math.pow(zSkew, 2.0) + zSkewM1 * zSkewP1, 1.5);
        }
        double hSkewM1 = SpecialMath.harmonic(this.cardinality, this.skew - 1.0);
        double hSkew = SpecialMath.harmonic(this.cardinality, this.skew);
        double hSkewP1 = this.denomCache;
        double numer = 2.0 * Math.pow(hSkew, 3.0) - 3.0 * hSkewM1 * hSkew * hSkewP1 + SpecialMath.harmonic(this.cardinality, this.skew - 2.0) * Math.pow(hSkewP1, 2.0);
        double denom = Math.pow(hSkewP1, 3.0) * Math.pow((-Math.pow(hSkew, 2.0) + hSkewM1 * hSkewP1) / Math.pow(hSkewP1, 2.0), 1.5);
        return numer / denom;
    }

    @Override
    public double min() {
        return 1.0;
    }

    @Override
    public double max() {
        return this.cardinality;
    }
}

