/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;
import jsat.math.TrigMath;

public final class Logistic
extends ContinuousDistribution {
    private static final long serialVersionUID = -8720773286818833591L;
    private double mu;
    private double s;

    public Logistic(double mu, double s) {
        this.mu = mu;
        this.setS(s);
    }

    public double getS() {
        return this.s;
    }

    public double getMu() {
        return this.mu;
    }

    public void setMu(double mu) {
        this.mu = mu;
    }

    public void setS(double s) {
        if (s <= 0.0) {
            throw new ArithmeticException("The scale parameter must be > 0, not " + s);
        }
        this.s = s;
    }

    @Override
    public double pdf(double x) {
        return 1.0 / (4.0 * this.s) * Math.pow(TrigMath.sech((x - this.mu) / (2.0 * this.s)), 2.0);
    }

    @Override
    public double cdf(double x) {
        return 0.5 + 0.5 * Math.tanh((x - this.mu) / (2.0 * this.s));
    }

    @Override
    public double invCdf(double p) {
        return this.mu + this.s * Math.log(p / (1.0 - p));
    }

    @Override
    public double min() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "Logistic";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"\u03bc", "s"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.mu, this.s};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("\u03bc")) {
            this.setMu(value);
        } else if (var.equals("s")) {
            this.setS(value);
        }
    }

    @Override
    public ContinuousDistribution clone() {
        return new Logistic(this.mu, this.s);
    }

    @Override
    public void setUsingData(Vec data) {
        double newS = data.variance() * 0.3039635509270133;
        newS = Math.sqrt(newS);
        this.setS(newS);
        this.setMu(data.mean());
    }

    @Override
    public double mean() {
        return this.mu;
    }

    @Override
    public double median() {
        return this.mu;
    }

    @Override
    public double mode() {
        return this.mu;
    }

    @Override
    public double variance() {
        return 3.289868133696453 * this.s * this.s;
    }

    @Override
    public double skewness() {
        return 0.0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.mu);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.s);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Logistic other = (Logistic)obj;
        if (Double.doubleToLongBits(this.mu) != Double.doubleToLongBits(other.mu)) {
            return false;
        }
        return Double.doubleToLongBits(this.s) == Double.doubleToLongBits(other.s);
    }
}

