/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;
import jsat.math.SpecialMath;

public class Levy
extends ContinuousDistribution {
    private static final long serialVersionUID = 3132169946527422816L;
    private double location;
    private double scale;
    private double logScale;

    public Levy(double scale, double location) {
        this.setScale(scale);
        this.setLocation(location);
    }

    public void setScale(double scale) {
        if (scale <= 0.0 || Double.isNaN(scale) || Double.isInfinite(scale)) {
            throw new ArithmeticException("Scale must be a positive value, not " + scale);
        }
        this.scale = scale;
        this.logScale = Math.log(scale);
    }

    public double getScale() {
        return this.scale;
    }

    public void setLocation(double location) {
        if (Double.isNaN(location) || Double.isInfinite(location)) {
            throw new ArithmeticException("location must be a real number");
        }
        this.location = location;
    }

    public double getLocation() {
        return this.location;
    }

    @Override
    public double pdf(double x) {
        if (x < this.location) {
            return 0.0;
        }
        return Math.exp(this.logPdf(x));
    }

    @Override
    public double logPdf(double x) {
        if (x < this.location) {
            return Double.NEGATIVE_INFINITY;
        }
        double mu = x - this.location;
        return -(-mu * this.logScale + this.scale + 3.0 * mu * Math.log(mu) + mu * Math.log(Math.PI) + mu * Math.log(2.0)) / (2.0 * mu);
    }

    @Override
    public double cdf(double x) {
        if (x < this.location) {
            return 0.0;
        }
        return SpecialMath.erfc(Math.sqrt(this.scale / (2.0 * (x - this.location))));
    }

    @Override
    public double invCdf(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Invalid probability " + p);
        }
        return this.scale / (2.0 * Math.pow(SpecialMath.invErfc(p), 2.0)) + this.location;
    }

    @Override
    public double min() {
        return this.location;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "Levy";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"Scale", "Location"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.scale, this.location};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals(this.getVariables()[0])) {
            this.setScale(value);
        } else if (var.equals(this.getVariables()[1])) {
            this.setLocation(value);
        }
    }

    @Override
    public Levy clone() {
        return new Levy(this.scale, this.location);
    }

    @Override
    public void setUsingData(Vec data) {
        this.setLocation(data.min());
        this.setScale(2.0 * Math.pow(SpecialMath.invErfc(0.5), 2.0) * (data.median() - this.location));
    }

    @Override
    public double mean() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double mode() {
        return this.scale / 3.0 + this.location;
    }

    @Override
    public double standardDeviation() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double variance() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double skewness() {
        return Double.NaN;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.location);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.scale);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Levy other = (Levy)obj;
        if (Double.doubleToLongBits(this.location) != Double.doubleToLongBits(other.location)) {
            return false;
        }
        return Double.doubleToLongBits(this.scale) == Double.doubleToLongBits(other.scale);
    }
}

