/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import java.util.Random;
import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;
import jsat.math.SpecialMath;

public class Gamma
extends ContinuousDistribution {
    private static final long serialVersionUID = 6380493734491674483L;
    private double k;
    private double theta;

    public Gamma(double k, double theta) {
        this.k = k;
        this.theta = theta;
    }

    @Override
    public double pdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return Math.exp(this.logPdf(x));
    }

    @Override
    public double logPdf(double x) {
        double p5;
        double p4;
        double p3;
        double p2;
        double p1 = -this.k * Math.log(this.theta);
        double pdf = p1 + (p2 = this.k * Math.log(x)) + (p3 = -SpecialMath.lnGamma(this.k)) + (p4 = -x / this.theta) + (p5 = -Math.log(x));
        if (Double.isNaN(pdf) || Double.isInfinite(pdf)) {
            return -1.7976931348623157E308;
        }
        return pdf;
    }

    @Override
    public double cdf(double x) {
        if (x < 0.0) {
            throw new ArithmeticException("CDF goes from 0 to Infinity, " + x + " is invalid");
        }
        return SpecialMath.gammaP(this.k, x / this.theta);
    }

    @Override
    public double invCdf(double p) {
        return SpecialMath.invGammaP(p, this.k) * this.theta;
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "Gamma";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"k", "theta"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.k, this.theta};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("k")) {
            this.k = value;
        } else if (var.equals("theta")) {
            this.theta = value;
        }
    }

    @Override
    public ContinuousDistribution clone() {
        return new Gamma(this.k, this.theta);
    }

    @Override
    public void setUsingData(Vec data) {
        this.theta = data.variance() / data.mean();
        this.k = data.mean() / this.theta;
    }

    @Override
    public double mean() {
        return this.k * this.theta;
    }

    @Override
    public double median() {
        return SpecialMath.invGammaP(this.k, 0.5) * this.theta;
    }

    @Override
    public double mode() {
        if (this.k < 1.0) {
            throw new ArithmeticException("No mode for k < 1");
        }
        return (this.k - 1.0) * this.theta;
    }

    @Override
    public double variance() {
        return this.k * this.theta * this.theta;
    }

    @Override
    public double skewness() {
        return 2.0 / Math.sqrt(this.k);
    }

    @Override
    public double[] sample(int numSamples, Random rand) {
        double[] toRet = new double[numSamples];
        if (this.k >= 1.0) {
            double d = this.k - 0.3333333333333333;
            double c = 1.0 / Math.sqrt(9.0 * d);
            block0: for (int i = 0; i < toRet.length; ++i) {
                double v;
                double xSqrd;
                double u;
                do {
                    double squeezeCheck;
                    double x = 0.0;
                    xSqrd = 0.0;
                    v = 0.0;
                    while (v <= 0.0) {
                        x = rand.nextGaussian();
                        v = 1.0 + c * x;
                    }
                    v = v * v * v;
                    u = rand.nextDouble();
                    if (!(u < (squeezeCheck = 1.0 - 0.0331 * (xSqrd = x * x) * xSqrd))) continue;
                    toRet[i] = this.theta * d * v;
                    continue block0;
                } while (!(Math.log(u) < 0.5 * xSqrd + d * (1.0 - v + Math.log(v))));
                toRet[i] = this.theta * d * v;
            }
        } else {
            Gamma shifted = new Gamma(this.k + 1.0, 1.0);
            double[] gs = shifted.sample(numSamples, rand);
            for (int i = 0; i < toRet.length; ++i) {
                toRet[i] = this.theta * gs[i] * Math.pow(rand.nextDouble(), 1.0 / this.k);
            }
        }
        return toRet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.k);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.theta);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Gamma other = (Gamma)obj;
        if (Double.doubleToLongBits(this.k) != Double.doubleToLongBits(other.k)) {
            return false;
        }
        return Double.doubleToLongBits(this.theta) == Double.doubleToLongBits(other.theta);
    }
}

