/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.InPlaceTransform;
import jsat.linear.Vec;

public class StandardizeTransform
implements InPlaceTransform {
    private static final long serialVersionUID = -2349721113741805955L;
    private Vec means;
    private Vec stdDevs;

    public StandardizeTransform() {
    }

    public StandardizeTransform(DataSet dataset) {
        this.fit(dataset);
    }

    @Override
    public void fit(DataSet dataset) {
        Vec[] vecs = dataset.getColumnMeanVariance();
        this.means = vecs[0];
        this.stdDevs = vecs[1];
        for (int i = 0; i < this.stdDevs.length(); ++i) {
            this.stdDevs.set(i, Math.sqrt(this.stdDevs.get(i) + 1.0E-10));
        }
    }

    public StandardizeTransform(StandardizeTransform toCopy) {
        this.means = toCopy.means.clone();
        this.stdDevs = toCopy.stdDevs.clone();
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        DataPoint newDP = dp.clone();
        this.mutableTransform(newDP);
        return newDP;
    }

    @Override
    public void mutableTransform(DataPoint dp) {
        Vec toAlter = dp.getNumericalValues();
        toAlter.mutableSubtract(this.means);
        toAlter.mutablePairwiseDivide(this.stdDevs);
    }

    @Override
    public boolean mutatesNominal() {
        return false;
    }

    @Override
    public StandardizeTransform clone() {
        return new StandardizeTransform(this);
    }
}

