/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import jsat.DataSet;
import jsat.clustering.ClustererBase;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.distancemetrics.TrainableDistanceMetric;
import jsat.linear.vectorcollection.DefaultVectorCollection;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionUtils;
import jsat.parameters.Parameterized;
import jsat.utils.IndexTable;

public class LSDBC
extends ClustererBase
implements Parameterized {
    private static final long serialVersionUID = 6626217924334267681L;
    public static final int DEFAULT_NEIGHBORS = 15;
    public static final double DEFAULT_ALPHA = 4.0;
    private static final int UNCLASSIFIED = -1;
    private DistanceMetric dm;
    private VectorCollection<VecPaired<Vec, Integer>> vc = new DefaultVectorCollection<VecPaired<Vec, Integer>>();
    private double alpha;
    private int k;

    public LSDBC(DistanceMetric dm, double alpha, int neighbors) {
        this.setDistanceMetric(dm);
        this.setAlpha(alpha);
        this.setNeighbors(neighbors);
    }

    public LSDBC(DistanceMetric dm, double alpha) {
        this(dm, alpha, 15);
    }

    public LSDBC(DistanceMetric dm) {
        this(dm, 4.0);
    }

    public LSDBC() {
        this(new EuclideanDistance());
    }

    public LSDBC(LSDBC toCopy) {
        this.alpha = toCopy.alpha;
        this.dm = toCopy.dm.clone();
        this.k = toCopy.k;
        this.vc = toCopy.vc.clone();
    }

    public void setVectorCollectionFactory(VectorCollection<VecPaired<Vec, Integer>> vc) {
        this.vc = vc;
    }

    public void setDistanceMetric(DistanceMetric dm) {
        if (dm != null) {
            this.dm = dm;
        }
    }

    private DistanceMetric getDistanceMetric() {
        return this.dm;
    }

    public void setNeighbors(int neighbors) {
        if (neighbors <= 0) {
            throw new ArithmeticException("Can not use a non positive number of neighbors");
        }
        this.k = neighbors;
    }

    public int getNeighbors() {
        return this.k;
    }

    public void setAlpha(double alpha) {
        if (alpha <= 0.0 || Double.isNaN(alpha) || Double.isInfinite(alpha)) {
            throw new ArithmeticException("Can not use the non positive scale value " + alpha);
        }
        this.alpha = alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public int[] cluster(DataSet dataSet, boolean parallel, int[] designations) {
        if (designations == null) {
            designations = new int[dataSet.getSampleSize()];
        }
        ArrayList<VecPaired<Vec, Integer>> vecs = new ArrayList<VecPaired<Vec, Integer>>(dataSet.getSampleSize());
        for (int i = 0; i < dataSet.getSampleSize(); ++i) {
            vecs.add(new VecPaired<Vec, Integer>(dataSet.getDataPoint(i).getNumericalValues(), i));
        }
        TrainableDistanceMetric.trainIfNeeded(this.dm, dataSet, parallel);
        this.vc.build(parallel, vecs, this.dm);
        List<List<? extends VecPaired<VecPaired<Vec, Integer>, Double>>> knnVecList = VectorCollectionUtils.allNearestNeighbors(this.vc, vecs, this.k + 1, parallel);
        IndexTable indexTable = new IndexTable(knnVecList, new Comparator(){

            public int compare(Object o1, Object o2) {
                List l1 = (List)o1;
                List l2 = (List)o2;
                return Double.compare(LSDBC.this.getEps(l1), LSDBC.this.getEps(l2));
            }
        });
        Arrays.fill(designations, -1);
        int clusterID = 0;
        for (int i = 0; i < indexTable.length(); ++i) {
            int p = indexTable.index(i);
            if (designations[p] != -1 || !this.localMax(p, knnVecList)) continue;
            this.expandCluster(p, clusterID++, knnVecList, designations);
        }
        return designations;
    }

    private void addSeed(List<? extends VecPaired<VecPaired<Vec, Integer>, Double>> neighbors, int i, int[] designations, int clusterID, Stack<Integer> seeds) {
        int index = neighbors.get(i).getVector().getPair();
        if (designations[index] != -1) {
            return;
        }
        designations[index] = clusterID;
        seeds.add(index);
    }

    private double getEps(List<? extends VecPaired<VecPaired<Vec, Integer>, Double>> neighbors) {
        return neighbors.get(this.k).getPair();
    }

    private boolean localMax(int p, List<List<? extends VecPaired<VecPaired<Vec, Integer>, Double>>> knnVecList) {
        List<? extends VecPaired<VecPaired<Vec, Integer>, Double>> neighbors = knnVecList.get(p);
        double myEps = this.getEps(neighbors);
        for (int i = 1; i < neighbors.size(); ++i) {
            int neighborP = neighbors.get(i).getVector().getPair();
            if (!(this.getEps(knnVecList.get(neighborP)) < myEps)) continue;
            return false;
        }
        return true;
    }

    private void expandCluster(int p, int clusterID, List<List<? extends VecPaired<VecPaired<Vec, Integer>, Double>>> knnVecList, int[] designations) {
        designations[p] = clusterID;
        Stack<Integer> seeds = new Stack<Integer>();
        List<? extends VecPaired<VecPaired<Vec, Integer>, Double>> neighbors = knnVecList.get(p);
        for (int i = 1; i < neighbors.size(); ++i) {
            this.addSeed(neighbors, i, designations, clusterID, seeds);
        }
        double pointEps = this.getEps(neighbors);
        int n = neighbors.get(this.k).length();
        double scale = Math.pow(2.0, this.alpha / (double)n);
        while (!seeds.isEmpty()) {
            int currentP = seeds.pop();
            List<? extends VecPaired<VecPaired<Vec, Integer>, Double>> neighbors2 = knnVecList.get(currentP);
            double currentPEps = this.getEps(neighbors2);
            if (!(currentPEps <= scale * pointEps)) continue;
            for (int i = 1; i < neighbors2.size(); ++i) {
                this.addSeed(neighbors2, i, designations, clusterID, seeds);
            }
        }
    }

    @Override
    public LSDBC clone() {
        return new LSDBC();
    }
}

