/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.svm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jsat.distributions.kernels.KernelTrick;
import jsat.distributions.kernels.LinearKernel;
import jsat.linear.Vec;
import jsat.parameters.Parameter;
import jsat.utils.DoubleList;
import jsat.utils.ListUtils;
import jsat.utils.concurrent.ConcurrentCacheLRU;

public abstract class SupportVectorLearner
implements Serializable {
    static final long serialVersionUID = 210140232301130063L;
    @Parameter.ParameterHolder
    private KernelTrick kernel;
    protected List<Vec> vecs;
    protected double[] alphas;
    private CacheMode cacheMode;
    protected List<Double> accelCache = null;
    private double[][] fullCache;
    private ConcurrentCacheLRU<Integer, double[]> partialCache;
    private double[] specific_row_cache_values = null;
    private int specific_row_cache_row = -1;
    private double[] availableRow;
    private int cacheConst = 500;
    protected int evalCount = 0;
    protected int cacheEvictions = 0;

    protected void setAlphas(double[] alphas) {
        this.alphas = alphas;
        this.accelCache = this.kernel.getAccelerationCache(this.vecs);
    }

    protected SupportVectorLearner() {
        this(new LinearKernel(), CacheMode.NONE);
    }

    public SupportVectorLearner(KernelTrick kernel, CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        this.setKernel(kernel);
    }

    public SupportVectorLearner(SupportVectorLearner toCopy) {
        if (toCopy.kernel != null) {
            this.kernel = toCopy.kernel.clone();
        }
        if (toCopy.vecs != null) {
            this.vecs = new ArrayList<Vec>(toCopy.vecs.size());
            for (Vec v : toCopy.vecs) {
                this.vecs.add(v.clone());
            }
        }
        if (toCopy.alphas != null) {
            this.alphas = Arrays.copyOf(toCopy.alphas, toCopy.alphas.length);
        }
        this.cacheMode = toCopy.cacheMode;
        if (toCopy.accelCache != null) {
            this.accelCache = new DoubleList(toCopy.accelCache);
        }
        if (toCopy.fullCache != null) {
            this.fullCache = new double[toCopy.fullCache.length][];
            for (int i = 0; i < toCopy.fullCache.length; ++i) {
                this.fullCache[i] = Arrays.copyOf(toCopy.fullCache[i], toCopy.fullCache[i].length);
            }
        }
        if (toCopy.partialCache != null) {
            this.setCacheMode(this.cacheMode);
        }
        this.cacheConst = toCopy.cacheConst;
    }

    public void setKernel(KernelTrick kernel) {
        this.kernel = kernel;
    }

    public void setCacheValue(int cacheValue) {
        this.cacheConst = cacheValue;
    }

    public void setCacheSize(long N, long bytes) {
        int DS = 8;
        if ((bytes /= (long)DS) > N * N / 2L) {
            this.setCacheMode(CacheMode.FULL);
        } else {
            long bytesPerRow = N * (long)DS + 24L;
            int rows = (int)Math.min(Math.max(1L, bytes / bytesPerRow), Integer.MAX_VALUE);
            if (rows > 25) {
                this.setCacheValue(rows);
            } else {
                this.setCacheMode(CacheMode.NONE);
            }
        }
    }

    public int getCacheValue() {
        return this.cacheConst;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        int N;
        if (cacheMode == null) {
            this.fullCache = null;
            this.partialCache = null;
            this.availableRow = null;
            return;
        }
        this.cacheMode = cacheMode;
        if (this.vecs != null) {
            this.accelCache = this.kernel.getAccelerationCache(this.vecs);
        }
        this.evalCount = 0;
        this.cacheEvictions = 0;
        int n = N = this.vecs == null ? 0 : this.vecs.size();
        if (cacheMode == CacheMode.FULL && this.vecs != null) {
            this.fullCache = new double[N][];
            for (int i = 0; i < N; ++i) {
                this.fullCache[i] = new double[N - i];
                Arrays.fill(this.fullCache[i], Double.NaN);
            }
        } else if (cacheMode == CacheMode.ROWS && this.vecs != null) {
            this.partialCache = new ConcurrentCacheLRU(this.cacheConst);
        } else if (cacheMode == CacheMode.NONE) {
            this.fullCache = null;
        }
    }

    public KernelTrick getKernel() {
        return this.kernel;
    }

    protected double kEvalSum(Vec y) {
        if (this.alphas == null) {
            throw new RuntimeException("alphas have not been set");
        }
        return this.kernel.evalSum(this.vecs, this.accelCache, this.alphas, y, 0, this.alphas.length);
    }

    protected double kEval(Vec a, Vec b) {
        return this.kernel.eval(a, b);
    }

    protected double kEval(int a, int b) {
        double[] cache;
        if (this.cacheMode == CacheMode.FULL) {
            double val;
            if (a > b) {
                int tmp = a;
                a = b;
                b = tmp;
            }
            if (Double.isNaN(val = this.fullCache[a][b - a])) {
                double d = this.k(a, b);
                this.fullCache[a][b - a] = d;
                return d;
            }
            return val;
        }
        if (this.cacheMode == CacheMode.ROWS && (cache = this.specific_row_cache_row == a ? this.specific_row_cache_values : this.partialCache.get(a)) == null) {
            cache = new double[this.vecs.size()];
            Arrays.fill(cache, Double.NaN);
            double[] cache_missed = this.partialCache.putIfAbsentAndGet(a, cache);
            if (cache_missed != null) {
                cache = cache_missed;
            }
            if (Double.isNaN(cache[b])) {
                cache[b] = this.k(a, b);
                return cache[b];
            }
            return cache[b];
        }
        return this.k(a, b);
    }

    protected void accessingRow(int r) {
        if (r < 0) {
            this.specific_row_cache_row = -1;
            this.specific_row_cache_values = null;
            return;
        }
        if (this.cacheMode == CacheMode.ROWS) {
            double[] cache = this.partialCache.get(r);
            if (cache == null) {
                cache = new double[this.vecs.size()];
                Arrays.fill(cache, Double.NaN);
                double[] cache_missed = this.partialCache.putIfAbsentAndGet(r, cache);
                if (cache_missed != null) {
                    cache = cache_missed;
                }
            }
            this.specific_row_cache_values = cache;
            this.specific_row_cache_row = r;
        }
    }

    protected double k(int a, int b) {
        ++this.evalCount;
        return this.kernel.eval(a, b, this.vecs, this.accelCache);
    }

    protected void sparsify() {
        int N = this.vecs.size();
        int accSize = this.accelCache == null ? 0 : this.accelCache.size() / N;
        int svCount = 0;
        for (int i = 0; i < N; ++i) {
            if (this.alphas[i] == 0.0) continue;
            ListUtils.swap(this.vecs, svCount, i);
            if (this.accelCache != null) {
                for (int j = i * accSize; j < (i + 1) * accSize; ++j) {
                    ListUtils.swap(this.accelCache, svCount * accSize + j - i * accSize, j);
                }
            }
            this.alphas[svCount++] = this.alphas[i];
        }
        this.vecs = new ArrayList<Vec>(this.vecs.subList(0, svCount));
        this.alphas = Arrays.copyOfRange(this.alphas, 0, svCount);
    }

    public static enum CacheMode {
        NONE,
        FULL,
        ROWS;

    }
}

