/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.neuralnetwork.initializers;

import java.util.Random;
import jsat.classifiers.neuralnetwork.initializers.BiastInitializer;
import jsat.classifiers.neuralnetwork.initializers.WeightInitializer;
import jsat.linear.Matrix;
import jsat.linear.Vec;

public class GaussianNormalInit
implements WeightInitializer,
BiastInitializer {
    private static final long serialVersionUID = -882418891606717433L;
    private double stndDev;

    public GaussianNormalInit(double stndDev) {
        this.stndDev = stndDev;
    }

    public void setStndDev(double stndDev) {
        this.stndDev = stndDev;
    }

    public double getStndDev() {
        return this.stndDev;
    }

    @Override
    public void init(Matrix w, Random rand) {
        for (int i = 0; i < w.rows(); ++i) {
            for (int j = 0; j < w.cols(); ++j) {
                w.set(i, j, rand.nextGaussian() * this.stndDev);
            }
        }
    }

    @Override
    public void init(Vec b, int fanIn, Random rand) {
        for (int i = 0; i < b.length(); ++i) {
            b.set(i, rand.nextGaussian() * this.stndDev);
        }
    }

    @Override
    public GaussianNormalInit clone() {
        return new GaussianNormalInit(this.stndDev);
    }
}

