/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.evaluation;

import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.evaluation.ClassificationScore;

public abstract class SimpleBinaryClassMetric
implements ClassificationScore {
    private static final long serialVersionUID = -84479984342547212L;
    protected double tp;
    protected double tn;
    protected double fp;
    protected double fn;

    public SimpleBinaryClassMetric() {
    }

    public SimpleBinaryClassMetric(SimpleBinaryClassMetric toClone) {
        this.tp = toClone.tp;
        this.tn = toClone.tn;
        this.fp = toClone.fp;
        this.fn = toClone.fn;
    }

    @Override
    public void addResult(CategoricalResults prediction, int trueLabel, double weight) {
        int pred = prediction.mostLikely();
        if (pred == trueLabel) {
            if (pred == 0) {
                this.tp += weight;
            } else {
                this.tn += weight;
            }
        } else if (pred == 0) {
            this.fp += weight;
        } else {
            this.fn += weight;
        }
    }

    @Override
    public void prepare(CategoricalData toPredict) {
        this.fn = 0.0;
        this.fp = 0.0;
        this.tn = 0.0;
        this.tp = 0.0;
    }

    @Override
    public void addResults(ClassificationScore other) {
        SimpleBinaryClassMetric otherObj = (SimpleBinaryClassMetric)other;
        this.tp += otherObj.tp;
        this.tn += otherObj.tn;
        this.fp += otherObj.fp;
        this.fn += otherObj.fn;
    }

    @Override
    public abstract double getScore();

    @Override
    public boolean lowerIsBetter() {
        return false;
    }

    @Override
    public abstract SimpleBinaryClassMetric clone();
}

