/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.boosting;

import jsat.classifiers.Classifier;
import jsat.classifiers.boosting.Wagging;
import jsat.distributions.ContinuousDistribution;
import jsat.distributions.Normal;
import jsat.regression.Regressor;

public class WaggingNormal
extends Wagging {
    private static final long serialVersionUID = -4149453672311329863L;

    public WaggingNormal(Classifier weakLearner, int interations) {
        super((ContinuousDistribution)new Normal(1.0, 2.0), weakLearner, interations);
    }

    public WaggingNormal(Regressor weakLearner, int interations) {
        super((ContinuousDistribution)new Normal(1.0, 2.0), weakLearner, interations);
    }

    protected WaggingNormal(Wagging clone) {
        super(clone);
    }

    @Override
    public ContinuousDistribution getDistribution() {
        return super.getDistribution();
    }

    @Override
    public void setDistribution(ContinuousDistribution dist) {
        if (!(dist instanceof Normal)) {
            throw new RuntimeException("Only the Normal distribution is valid");
        }
        super.setDistribution(dist);
    }

    public void setMean(double mean) {
        if (Double.isInfinite(mean) || Double.isNaN(mean)) {
            throw new ArithmeticException("Mean must be a real number, not " + mean);
        }
        ((Normal)this.getDistribution()).setMean(mean);
    }

    public double getMean() {
        return ((Normal)this.getDistribution()).mean();
    }

    public void setStandardDeviations(double devs) {
        if (devs <= 0.0 || Double.isInfinite(devs) || Double.isNaN(devs)) {
            throw new ArithmeticException("The stnd devs must be a positive value");
        }
        ((Normal)this.getDistribution()).setStndDev(devs);
    }

    public double getStandardDeviations() {
        return ((Normal)this.getDistribution()).standardDeviation();
    }

    @Override
    public WaggingNormal clone() {
        return new WaggingNormal(this);
    }
}

