/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.bayesian.graphicalmodel;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DirectedGraph<N>
implements Cloneable {
    private Map<N, Pair<HashSet<N>, HashSet<N>>> nodes = new HashMap<N, Pair<HashSet<N>, HashSet<N>>>();

    public Set<N> getNodes() {
        return this.nodes.keySet();
    }

    public void addNodes(Collection<? extends N> c) {
        for (N n : c) {
            this.addNode(n);
        }
    }

    public void addNode(N node) {
        if (!this.nodes.containsKey(node)) {
            this.nodes.put(node, new Pair(new HashSet(), new HashSet()));
        }
    }

    public Set<N> getParents(N n) {
        Pair<HashSet<N>, HashSet<N>> p = this.nodes.get(n);
        if (p == null) {
            return null;
        }
        return p.getIncoming();
    }

    public Set<N> getChildren(N n) {
        Pair<HashSet<N>, HashSet<N>> p = this.nodes.get(n);
        if (p == null) {
            return null;
        }
        return p.getOutgoing();
    }

    public void removeNode(N node) {
        Pair<HashSet<N>, HashSet<N>> p = this.nodes.remove(node);
        if (p == null) {
            return;
        }
        HashSet<N> incomingNodes = p.getIncoming();
        for (N incomingNode : incomingNodes) {
            this.nodes.get(incomingNode).getOutgoing().remove(node);
        }
    }

    private boolean containsBoth(N a, N b) {
        return this.nodes.containsKey(a) && this.nodes.containsKey(b);
    }

    public void addEdge(N a, N b) {
        if (!this.containsBoth(a, b)) {
            return;
        }
        this.nodes.get(a).getOutgoing().add(b);
        this.nodes.get(b).getIncoming().add(a);
    }

    public void removeEdge(N a, N b) {
        if (!this.containsBoth(a, b)) {
            return;
        }
        this.nodes.get(a).getOutgoing().remove(b);
        this.nodes.get(b).getIncoming().remove(a);
    }

    public boolean containsNode(N a) {
        return this.nodes.containsKey(a);
    }

    protected DirectedGraph<N> clone() {
        DirectedGraph<N> clone = new DirectedGraph<N>();
        clone.addNodes(this.nodes.keySet());
        for (N key : this.nodes.keySet()) {
            Pair<HashSet<N>, HashSet<N>> p = this.nodes.get(key);
            for (N n : p.getIncoming()) {
                clone.nodes.get(key).getIncoming().add(n);
            }
            for (N n : p.getOutgoing()) {
                clone.nodes.get(key).getOutgoing().add(n);
            }
        }
        return clone;
    }

    private static class Pair<A, B> {
        A incoming;
        B outgoing;

        public Pair(A first, B second) {
            this.incoming = first;
            this.outgoing = second;
        }

        public A getIncoming() {
            return this.incoming;
        }

        public B getOutgoing() {
            return this.outgoing;
        }

        public void setIncoming(A first) {
            this.incoming = first;
        }

        public void setOutgoing(B outgoing) {
            this.outgoing = outgoing;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)obj;
            return this.incoming.equals(other.incoming) && this.outgoing.equals(other.outgoing);
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this.incoming != null ? this.incoming.hashCode() : 0);
            hash = 79 * hash + (this.outgoing != null ? this.outgoing.hashCode() : 0);
            return hash;
        }
    }
}

