/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers;

import jsat.classifiers.CategoricalResults;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.classifiers.DataPoint;
import jsat.exceptions.UntrainedModelException;

public class PriorClassifier
implements Classifier {
    private static final long serialVersionUID = 7763388716880766538L;
    private CategoricalResults cr;

    public PriorClassifier() {
    }

    public PriorClassifier(CategoricalResults cr) {
        this.cr = cr;
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        if (this.cr == null) {
            throw new UntrainedModelException("PriorClassifier has not been trained");
        }
        return this.cr;
    }

    @Override
    public void train(ClassificationDataSet dataSet, boolean parallel) {
        this.train(dataSet);
    }

    @Override
    public void train(ClassificationDataSet dataSet) {
        this.cr = new CategoricalResults(dataSet.getPredicting().getNumOfCategories());
        for (int i = 0; i < dataSet.getSampleSize(); ++i) {
            this.cr.incProb(dataSet.getDataPointCategory(i), dataSet.getDataPoint(i).getWeight());
        }
        this.cr.normalize();
    }

    @Override
    public boolean supportsWeightedData() {
        return true;
    }

    @Override
    public Classifier clone() {
        PriorClassifier clone = new PriorClassifier();
        if (this.cr != null) {
            clone.cr = this.cr.clone();
        }
        return clone;
    }
}

