/*
 * Decompiled with CFR 0.152.
 */
package medusa.stringconnection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import medusa.graph.Edge;
import medusa.graph.Graph;

public class GetGraph
implements Runnable {
    private Thread me;
    private boolean done;
    private String url;
    private int port;
    private ArrayList selection;
    private Graph g;
    private float cutoff;
    int progress = 0;

    public GetGraph(String url, int port, ArrayList selection, float cutoff) {
        this.url = url;
        this.port = port;
        this.selection = selection;
        this.cutoff = cutoff;
    }

    public Graph getGraph() {
        return this.g;
    }

    public void start() {
        if (this.me == null) {
            this.me = new Thread(this);
        }
        this.me.start();
    }

    public void stop() {
        if (this.me != null) {
            this.me = null;
        }
    }

    @Override
    public void run() {
        Thread myThread = Thread.currentThread();
        this.done = false;
        if (this.me == myThread) {
            try {
                this.getGraphFromString();
            }
            catch (IOException ie) {
                this.g = new Graph();
            }
            this.done = true;
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isDone() {
        return this.done;
    }

    public void getGraphFromString() throws IOException {
        String inLine;
        this.progress = 0;
        this.g = new Graph();
        Socket stringSocket = new Socket(this.url, this.port);
        PrintWriter out = new PrintWriter(stringSocket.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(stringSocket.getInputStream()));
        StringBuffer temp = new StringBuffer();
        Iterator select = this.selection.iterator();
        while (select.hasNext()) {
            temp.append("GI:");
            String send = (String)select.next();
            temp.append(send);
            temp.append("\n");
        }
        temp.append("bye");
        out.println(temp.toString());
        while (!in.ready()) {
        }
        while ((inLine = in.readLine()) != null) {
            if (inLine.length() <= 10) continue;
            ++this.progress;
            this.parseEdge(this.g, inLine);
        }
        out.close();
        in.close();
        stringSocket.close();
    }

    private void parseEdge(Graph g, String inLine) {
        String[] result = inLine.split("\\t+");
        float combined = Float.parseFloat(result[result.length - 1]) / 1000.0f;
        if (combined < this.cutoff) {
            return;
        }
        if (inLine.compareTo("Not found") == 0) {
            return;
        }
        Pattern genePattern = Pattern.compile("^\\d+\\.([\\w\\d]+)\\.*");
        String n1 = result[0];
        String n2 = result[1];
        Matcher matcher = genePattern.matcher(result[0]);
        if (matcher.find()) {
            n1 = matcher.group(1);
        }
        if ((matcher = genePattern.matcher(result[1])).find()) {
            n2 = matcher.group(1);
        }
        for (int i = 2; i < result.length - 1; ++i) {
            float confidence = Float.parseFloat(result[i]) / 1000.0f;
            if (!((double)confidence > 0.0)) continue;
            Edge e = new Edge(n1, n2, confidence, i - 1);
            g.addEdge(e);
        }
    }
}

