/*
 * Decompiled with CFR 0.152.
 */
package medusa.stringconnection;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CallString
implements Runnable {
    private Thread me;
    private boolean done;
    private String url;
    private int port;
    private String[] queries;
    private JPanel resultPanel;
    int progress = 0;

    public CallString(String url, int port, String[] queries) {
        this.url = url;
        this.port = port;
        this.queries = queries;
    }

    public JPanel getPanel() {
        return this.resultPanel;
    }

    public void start() {
        if (this.me == null) {
            this.me = new Thread(this);
        }
        this.me.start();
    }

    public void stop() {
        if (this.me != null) {
            this.me = null;
        }
    }

    @Override
    public void run() {
        Thread myThread = Thread.currentThread();
        this.done = false;
        if (this.me == myThread) {
            try {
                this.resultPanel = this.callString();
            }
            catch (IOException ie) {
                this.resultPanel = this.errorPanel("Database not responding");
            }
        }
        this.done = true;
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isDone() {
        return this.done;
    }

    public JPanel callString() throws IOException {
        this.progress = 0;
        JPanel selectPanel = new JPanel();
        selectPanel.setBackground(new Color(255, 255, 255));
        selectPanel.setLayout(new BoxLayout(selectPanel, 1));
        Socket stringSocket = new Socket(this.url, this.port);
        PrintWriter out = new PrintWriter(stringSocket.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(stringSocket.getInputStream()));
        int count = 0;
        for (int n = 0; n < this.queries.length; ++n) {
            ++this.progress;
            out.println("GN:" + this.queries[n]);
            while (!in.ready()) {
            }
            String inLine = in.readLine();
            if (inLine == null) continue;
            String[] result = inLine.split("[\\n\\t]");
            for (int i = 0; i < result.length; ++i) {
                if (this.checkError(result[i])) {
                    out.close();
                    in.close();
                    stringSocket.close();
                    return this.errorPanel("Database is not responding");
                }
                result[i] = result[i].replaceAll(" ", "");
                if (result[i].length() <= 1) continue;
                JRadioButton jr = new JRadioButton(result[i]);
                jr.setBackground(new Color(255, 255, 255));
                selectPanel.add(jr);
                ++count;
            }
        }
        out.close();
        in.close();
        stringSocket.close();
        if (count == 0) {
            selectPanel.add(new JLabel("Sorry, no matches found"));
        }
        return selectPanel;
    }

    private JPanel errorPanel() {
        return this.errorPanel("STRING is not responding: server may be down");
    }

    private JPanel errorPanel(String text) {
        JPanel errorPanel = new JPanel();
        errorPanel.setLayout(new BoxLayout(errorPanel, 1));
        JLabel error = new JLabel(text);
        errorPanel.add(error);
        errorPanel.add(new JLabel("If this problem persists, please contact"));
        errorPanel.add(new JLabel("hooper@embl.de"));
        errorPanel.add(error);
        return errorPanel;
    }

    private boolean checkError(String inLine) {
        return inLine.startsWith("Error");
    }
}

