/*
 * Decompiled with CFR 0.152.
 */
package medusa.spectral;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import medusa.spectral.KMeansPoint;
import medusa.spectral.cluster;

public class KMeans {
    private int k;
    private cluster[] clusters;
    private int nIterations;
    private Vector kMeansPoints;
    private String inputFileName;
    int dimensions;

    public KMeans(int k, String inputFileName) {
        this.k = k;
        this.inputFileName = inputFileName;
        this.clusters = new cluster[this.k];
        this.nIterations = 0;
        this.kMeansPoints = new Vector();
    }

    public KMeans(int k, List<KMeansPoint> kMeansPoints) {
        this.k = k;
        this.clusters = new cluster[this.k];
        this.nIterations = 0;
        this.kMeansPoints = new Vector<KMeansPoint>(kMeansPoints);
        this.dimensions = kMeansPoints.get(0).getDimensions();
    }

    public void readData() throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(this.inputFileName));
        String line = "";
        while ((line = in.readLine()) != null) {
            String[] result = line.split("\t");
            if (result.length != 3) continue;
            KMeansPoint dp = new KMeansPoint(result[0], Double.parseDouble(result[1]), Double.parseDouble(result[2]));
            dp.assignToCluster(0);
            this.kMeansPoints.add(dp);
        }
        in.close();
    }

    public Vector<KMeansPoint> getVector() {
        return this.kMeansPoints;
    }

    public void runKMeans() {
        for (int i = 0; i < this.k; ++i) {
            this.clusters[i] = new cluster(i);
            this.clusters[i].setMean((KMeansPoint)this.kMeansPoints.get((int)(Math.random() * (double)this.kMeansPoints.size())));
        }
        do {
            Iterator i = this.kMeansPoints.iterator();
            while (i.hasNext()) {
                this.assignToCluster((KMeansPoint)i.next());
            }
            ++this.nIterations;
        } while (this.updateMeans());
    }

    private void assignToCluster(KMeansPoint dp) {
        int currentCluster = dp.getClusterNumber();
        double minDistance = KMeansPoint.distance(dp, this.clusters[currentCluster].getMean());
        for (int i = 0; i < this.k; ++i) {
            double tdist = KMeansPoint.distance(dp, this.clusters[i].getMean());
            if (!(tdist < minDistance)) continue;
            minDistance = tdist;
            currentCluster = i;
        }
        dp.assignToCluster(currentCluster);
    }

    private boolean updateMeans() {
        boolean reply = false;
        double[] x = new double[this.k];
        double[] y = new double[this.k];
        double[][] means = new double[this.k][this.dimensions];
        int[] size = new int[this.k];
        KMeansPoint[] pastMeans = new KMeansPoint[this.k];
        for (int i = 0; i < this.k; ++i) {
            x[i] = 0.0;
            y[i] = 0.0;
            size[i] = 0;
            pastMeans[i] = this.clusters[i].getMean();
        }
        for (KMeansPoint dp : this.kMeansPoints) {
            int currentCluster = dp.getClusterNumber();
            for (int index = 0; index < this.dimensions; ++index) {
                double[] dArray = means[currentCluster];
                int n = index;
                dArray[n] = dArray[n] + dp.getCoords()[index];
            }
            int n = currentCluster;
            size[n] = size[n] + 1;
        }
        for (int j = 0; j < this.k; ++j) {
            if (size[j] == 0) continue;
            int index = 0;
            while (index < this.dimensions) {
                double[] dArray = means[j];
                int n = index++;
                dArray[n] = dArray[n] / (double)size[j];
            }
            KMeansPoint temp = new KMeansPoint("temp", means[j]);
            temp.assignToCluster(j);
            this.clusters[j].setMean(temp);
            if (KMeansPoint.distance(pastMeans[j], this.clusters[j].getMean()) == 0.0) continue;
            reply = true;
        }
        return reply;
    }

    public Vector<KMeansPoint>[] getClusters() {
        int i;
        Vector[] myclusters = new Vector[this.k];
        for (i = 0; i < this.k; ++i) {
            myclusters[i] = new Vector();
        }
        for (i = 0; i < this.kMeansPoints.size(); ++i) {
            KMeansPoint km = (KMeansPoint)this.kMeansPoints.get(i);
            myclusters[km.getClusterNumber()].add(km);
        }
        return myclusters;
    }

    public int getK() {
        return this.k;
    }

    public cluster getCluster(int index) {
        return this.getCluster(index);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.kMeansPoints.size(); ++i) {
            sb.append(this.kMeansPoints.elementAt(i).toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public Vector getDataPoints() {
        return this.kMeansPoints;
    }

    public Map<String, Integer> getClusterMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.kMeansPoints.size(); ++i) {
            KMeansPoint km = (KMeansPoint)this.kMeansPoints.get(i);
            map.put(km.getLabel(), km.getClusterNumber());
        }
        return map;
    }

    public int getSmallestClusterSize() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.kMeansPoints.size(); ++i) {
            KMeansPoint km = (KMeansPoint)this.kMeansPoints.get(i);
            Integer cluster2 = km.getClusterNumber();
            Integer count = 1;
            if (map.containsKey(cluster2)) {
                count = (Integer)map.get(cluster2) + 1;
            }
            map.put(cluster2, count);
        }
        Integer min = Integer.MAX_VALUE;
        for (Integer count : map.values()) {
            if (min <= count) continue;
            min = count;
        }
        return min;
    }

    public static void main(String[] args) {
        KMeans km = new KMeans(2, "/scratch/home2/testcluster.txt");
        try {
            km.readData();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(-1);
        }
        km.runKMeans();
        System.out.println(km);
    }
}

