/*
 * Decompiled with CFR 0.152.
 */
package medusa.graphedit;

import java.awt.Color;
import java.util.Iterator;
import medusa.graph.Graph;
import medusa.graph.Node;
import medusa.graphedit.EdgeTableModel;

public class NodeTableModel
extends EdgeTableModel {
    public String[] columnNames = new String[]{"Name", "x", "y", "Shape", "Color"};
    final Object[] reference = new Object[]{new String(), new Double(0.0), new Double(0.0), new Integer(1), new Color(0, 0, 0)};

    public NodeTableModel(Graph g) {
        this.setG(g);
        this.init();
    }

    @Override
    public void init() {
        this.columnCount = 5;
        this.rowCount = this.getG().getNodeSize();
        this.data = new Object[this.rowCount][this.columnCount];
        int count = 0;
        Iterator<Node> nodeI = this.getG().nodesIterator();
        while (nodeI.hasNext()) {
            Node n = nodeI.next();
            this.data[count][0] = n.getLabel();
            this.data[count][1] = new Double(n.getX());
            this.data[count][2] = new Double(n.getY());
            this.data[count][3] = new Integer(n.getShape());
            this.data[count][4] = n.getColor();
            ++count;
        }
    }

    @Override
    public String getColumnName(int column) {
        String retValue = this.columnNames[column];
        return retValue;
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        Class<?> retValue = this.reference[columnIndex].getClass();
        return retValue;
    }

    public Node[] getNodes() {
        Node[] n = new Node[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            n[i] = new Node((String)this.data[i][0], (Double)this.data[i][1], (Double)this.data[i][2], (Integer)this.data[i][3], (Color)this.data[i][4]);
        }
        return n;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 0;
    }
}

