/*
 * Decompiled with CFR 0.152.
 */
package medusa.graphedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import medusa.graph.Edge;
import medusa.graph.Graph;
import medusa.graph.Node;
import medusa.graphedit.ColorEditor;
import medusa.graphedit.EdgeTableModel;
import medusa.graphedit.NewEdgeDialog;
import medusa.graphedit.NodeColorRenderer;
import medusa.graphedit.NodeNameEditor;
import medusa.graphedit.NodeTableModel;
import medusa.graphedit.TableSorter;

public class EditGraphDialog
extends JDialog {
    private EdgeTableModel edgeTableModel;
    private NodeTableModel nodeTableModel;
    private NewEdgeDialog newEdgeDialog;
    private Graph g;
    private JButton addButton;
    private JButton cancelButton;
    private JPanel controlPanel;
    private JButton deleteButton;
    private JTable edgeTable;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JTable nodeTable;
    private JButton okButton;
    private JLabel titleLabel;

    public EditGraphDialog(Frame parent, boolean modal) {
        super(parent, modal);
    }

    private void setModels() {
        this.edgeTableModel = new EdgeTableModel(this.g);
        this.nodeTableModel = new NodeTableModel(this.g);
        this.newEdgeDialog = new NewEdgeDialog(null, true);
        this.initComponents();
        TableColumn col = this.nodeTable.getColumnModel().getColumn(0);
        col.setCellEditor(new NodeNameEditor(this.g, this));
    }

    private void updateTables() {
        this.edgeTableModel.init();
        this.edgeTable.updateUI();
        this.nodeTableModel.init();
        this.nodeTable.updateUI();
    }

    protected void notifyNodeNameChange(String oldLabel, String newLabel) {
        this.edgeTableModel.init();
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        TableSorter edgeSorter = new TableSorter(this.edgeTableModel);
        this.edgeTable = new JTable();
        this.edgeTable.setModel(edgeSorter);
        edgeSorter.setTableHeader(this.edgeTable.getTableHeader());
        this.jPanel2 = new JPanel();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        TableSorter nodeSorter = new TableSorter(this.nodeTableModel);
        this.nodeTable = new JTable();
        this.nodeTable.setModel(nodeSorter);
        nodeSorter.setTableHeader(this.nodeTable.getTableHeader());
        this.nodeTable.setDefaultRenderer(Color.class, new NodeColorRenderer(true));
        this.nodeTable.setDefaultEditor(Color.class, new ColorEditor());
        this.controlPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText("Graph editor");
        this.getContentPane().add((Component)this.titleLabel, "North");
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.edgeTable);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 0));
        this.jPanel2.setBorder(BorderFactory.createBevelBorder(0));
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditGraphDialog.this.addButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.addButton);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditGraphDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.deleteButton);
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jTabbedPane1.addTab("Edges", this.jPanel1);
        this.jScrollPane2.setViewportView(this.nodeTable);
        this.jTabbedPane1.addTab("Nodes", this.jScrollPane2);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditGraphDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.controlPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditGraphDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.controlPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.controlPanel, "South");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.edgeTableModel.removeEdges();
        this.edgeTable.updateUI();
        this.nodeTableModel.init();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.newEdgeDialog.setVisible(true);
        Edge e = this.newEdgeDialog.getEdge();
        this.g.addEdge(e);
        this.edgeTableModel.init();
        TableSorter te = new TableSorter(this.edgeTableModel);
        this.edgeTable.setModel(te);
        te.setTableHeader(this.edgeTable.getTableHeader());
        this.edgeTable.updateUI();
        this.nodeTableModel.init();
        TableSorter tn = new TableSorter(this.nodeTableModel);
        this.nodeTable.setModel(tn);
        tn.setTableHeader(this.nodeTable.getTableHeader());
        this.nodeTable.updateUI();
        JOptionPane.showMessageDialog(null, "Edge added. Remember to set X and Y position of\nany new nodes that have resulted from this addition.");
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.g = this.getGraph();
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new EditGraphDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public void setGraph(Graph g) {
        this.g = g;
        this.setModels();
    }

    private Graph newGraph() {
        return new Graph();
    }

    public Graph getGraph() {
        Graph graph = this.edgeTableModel.getGraph();
        Node[] n = this.nodeTableModel.getNodes();
        for (int i = 0; i < n.length; ++i) {
            graph.setNode(n[i]);
        }
        return graph;
    }
}

