/*
 * Decompiled with CFR 0.152.
 */
package medusa.graph;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import medusa.graph.BasicGraph;
import medusa.graph.Edge;
import medusa.graph.Node;
import medusa.graph.UniqueEdge;

public class Graph
extends BasicGraph
implements Serializable,
Cloneable {
    final int MAX_PARALLEL = 40;

    public void addGraph(BasicGraph g) {
        Iterator<Edge> i = g.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            this.addEdge(e);
        }
    }

    public void subtractGraph(BasicGraph g) {
        Iterator<Edge> i = g.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            this.removeEdge(e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Graph g = new Graph();
        g.addGraph(this);
        g.copyNodeSettings(this);
        return g;
    }

    public Iterator<Edge> edgesIterator(String lbl) {
        ArrayList<Edge> temp = new ArrayList<Edge>();
        Iterator<Edge> i = this.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            if (!e.contains(lbl)) continue;
            temp.add(e);
        }
        return temp.iterator();
    }

    public ArrayList<Node> getFixed() {
        ArrayList<Node> fixedNodes = new ArrayList<Node>();
        Iterator<Node> i = this.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            if (!n.isFixed()) continue;
            fixedNodes.add(n);
        }
        return fixedNodes;
    }

    public void removeFixed() {
        ArrayList<Node> a = this.getFixed();
        for (Node n : a) {
            this.removeEdgeByLabel(n.getLabel());
        }
    }

    public void rescaleNodes(int scale) {
        Iterator<Node> i = this.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            n.rescale(scale);
        }
    }

    public void rescaleNodes(int xScale, int yScale) {
        Iterator<Node> i = this.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            n.rescale(xScale, yScale);
        }
    }

    public HashMap<String, Integer> nodesMap() {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        int count = 0;
        Iterator<Node> i = this.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            hm.put(n.getLabel(), new Integer(count));
            ++count;
        }
        return hm;
    }

    public void divideNodePosition(double d) {
        double max = 0.0;
        Iterator<Node> i = this.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            n.setX(n.getX() / d);
            n.setY(n.getY() / d);
        }
    }

    private Edge[] edgeArray() {
        return this.getEdges().toArray(new Edge[0]);
    }

    public void subtractGraph(Graph g) {
        Iterator<Edge> i = g.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            this.removeEdge(e);
        }
    }

    protected List<Edge> cloneEdges() {
        ArrayList<Edge> list = new ArrayList<Edge>();
        Iterator<Edge> i = this.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            list.add(new Edge(e));
        }
        return list;
    }

    public void cropEdges(double confidenceCutoff) {
        List<Edge> list = this.cloneEdges();
        for (Edge temp : list) {
            if (!((double)temp.getConf() < confidenceCutoff)) continue;
            this.removeEdge(temp);
        }
    }

    public void removeEdgeByLabel(String lbl) {
        List<Edge> list = this.cloneEdges();
        for (Edge temp : list) {
            if (!temp.contains(lbl)) continue;
            this.removeEdge(temp);
        }
    }

    public void tracePath(ArrayList unresolved, Node n) {
        Edge e;
        while ((e = this.getAdjacent(unresolved, n)) != null) {
            unresolved.remove(e);
            Node n2 = e.getComplement(n.getLabel());
            this.tracePath(unresolved, n2);
            System.out.print(n2.getLabel() + "-");
        }
    }

    public Edge getAdjacent(ArrayList unresolved, Node node) {
        for (Edge e : unresolved) {
            Node n = e.getComplement(node.getLabel());
            if (n == null) continue;
            return e;
        }
        return null;
    }

    public String reportUnique() {
        StringBuffer sb = new StringBuffer();
        Iterator<UniqueEdge> i = this.uniqueEdgesIterator();
        while (i.hasNext()) {
            UniqueEdge e = i.next();
            sb.append("\n");
            sb.append(e.getFromName());
            sb.append("\t");
            sb.append(e.getToName());
        }
        return sb.toString();
    }

    public void defaultGraph() {
        Edge e1 = new Edge("n1", "n2", 4);
        Edge e2 = new Edge("n2", "n3", 5);
        Edge e3 = new Edge("n1", "n2", 5);
        Edge e4 = new Edge("n1", "n4", 1);
        Edge e5 = new Edge("n2", "n3", 1);
        this.addEdge(e1);
        this.addEdge(e2);
        this.addEdge(e3);
        this.addEdge(e4);
        this.addEdge(e5);
    }

    public void setNodeColor(Color color) {
        Iterator<Node> i = this.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            n.setColor(color);
        }
    }

    public void setNodeShape(int shape) {
        Iterator<Node> i = this.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            n.setShape(shape);
        }
    }

    public void setNodeAnnotation(String name, String annotation) {
        Node n = this.getNode(name);
        if (n != null) {
            n.setAnnotation(annotation);
        }
    }

    public void printNodeAnnotation() {
        Iterator<Node> i = this.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            System.out.println(n.getAnnotation());
        }
    }

    public StringBuffer getNodeList() {
        StringBuffer sb = new StringBuffer();
        Iterator<Node> i = this.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            sb.append(n.getLabel());
            sb.append("\n");
        }
        return sb;
    }

    public Graph shrinkGraph(Graph g) {
        Iterator<Node> i = g.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            if (n.getConnections() > 1) continue;
            Graph temp = g.subGraph(n);
            g.subtractGraph(temp);
        }
        return g;
    }

    public Graph subGraph(Node[] nodes) {
        Graph sub = new Graph();
        for (Node node : nodes) {
            sub.addGraph(this.subGraph(node));
        }
        return sub;
    }

    public Graph subGraph(Node node) {
        Graph sub = new Graph();
        Iterator<Edge> i = this.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            if (!e.containsNode(node)) continue;
            sub.addEdge(e);
            Node n = e.getComplement(node);
        }
        return sub;
    }

    private Graph getFixedSubgraph() {
        ArrayList<Node> nodes = this.getFixed();
        Node[] ns = nodes.toArray(new Node[0]);
        Graph fixedSubgraph = this.subGraph(ns);
        return fixedSubgraph;
    }

    public void growSelection() {
        Graph grow = this.getFixedSubgraph();
        Iterator<Node> i = grow.nodesIterator();
        while (i.hasNext()) {
            Node n = this.getNode(i.next().getLabel());
            n.setFixed(true);
        }
    }

    public void rescaleConfidence() {
        Edge e;
        float max = 0.0f;
        Iterator<Edge> i = this.edgesIterator();
        while (i.hasNext()) {
            e = i.next();
            if (!(e.getConf() > max)) continue;
            max = e.getConf();
        }
        i = this.edgesIterator();
        while (i.hasNext()) {
            e = i.next();
            e.setConf(e.getConf() / max);
        }
    }

    public void rescaleNodePercentage() {
        float max = 100.0f;
        Iterator<Edge> i = this.edgesIterator();
        while (i.hasNext()) {
            Edge e = i.next();
            e.setConf(e.getConf() / max);
        }
    }

    public void autoFixOrientation() {
        Edge[] edgeArray = this.edgeArray();
        int nedges = edgeArray.length;
        boolean[] edgeDone = new boolean[nedges];
        for (int i = 0; i < nedges; ++i) {
            edgeDone[i] = false;
        }
        int[] edgeList = new int[40];
        for (int i = 0; i < 40; ++i) {
            edgeList[i] = 0;
        }
        double alpha = 1.0;
        int matches = 0;
        for (int i = 0; i < nedges; ++i) {
            if (edgeDone[i]) continue;
            matches = 0;
            edgeList[0] = i;
            for (int j = 0; j < nedges; ++j) {
                if (i == j || !edgeArray[i].sameName(edgeArray[j])) continue;
                edgeList[++matches] = j;
                edgeDone[j] = true;
            }
            if (matches == 0) {
                edgeArray[i].setOrientation(0.0);
                continue;
            }
            double startAlpha = matches % 2 == 1 ? (double)matches * -alpha / 2.0 : (double)matches * -alpha / 2.0;
            for (int k = 0; k <= matches; ++k) {
                edgeArray[edgeList[k]].setOrientation(this.isOppositeEdge(edgeArray[edgeList[k]], edgeArray[i]) * (startAlpha + (double)k * alpha));
            }
        }
    }

    public double isOppositeEdge(Edge e1, Edge e2) {
        if (e1.oppositeName(e2)) {
            return -1.0;
        }
        return 1.0;
    }

    public void rescaleNodes(double scale) {
        Iterator<Node> it = this.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            node.setX(node.getX() * scale);
            node.setY(node.getY() * scale);
        }
    }

    public StringBuffer nodesConnectivityReport() {
        StringBuffer sb = new StringBuffer();
        Iterator<Node> i = this.nodesIterator();
        while (i.hasNext()) {
            Node n = i.next();
            sb.append(n.getLabel()).append("\t");
            sb.append(n.getConnections());
            sb.append("\n");
        }
        return sb;
    }

    public StringBuffer generalStats() {
        double connectionDegree = this.connectionDegree();
        StringBuffer sb = new StringBuffer();
        sb.append("Connection degree: " + this.connectionDegree());
        return sb;
    }

    private double connectionDegree() {
        int totalUniqueEdges = this.getUniqueEdgeSize();
        int totalNodes = this.getNodeSize();
        int maximum = 0;
        for (int i = 1; i < totalNodes; ++i) {
            maximum += i - 1;
        }
        double connectionDegree = (double)totalUniqueEdges / (double)maximum;
        return connectionDegree;
    }

    public void assignColorByMap(Map<String, Color> map) {
        for (String label : map.keySet()) {
            this.getNode(label).setColor(map.get(label));
        }
    }
}

