/*
 * Decompiled with CFR 0.152.
 */
package medusa.graph;

import medusa.graph.BasicEdge;
import medusa.graph.Node;

public class Edge
extends BasicEdge {
    private float conf;
    private double orientation = 0.0;
    private int type;

    public Edge(String n1, String n2, float conf, int type) {
        this.n1 = n1;
        this.n2 = n2;
        this.conf = conf;
        this.type = type;
    }

    public Edge(String n1, String n2, float conf, int type, double orientation) {
        this.n1 = n1;
        this.n2 = n2;
        this.conf = conf;
        this.type = type;
        this.orientation = orientation;
    }

    public Edge(String n1, String n2, Integer type, Double orientation, Float conf) {
        this.n1 = n1;
        this.n2 = n2;
        this.conf = conf.floatValue();
        this.type = type;
        this.orientation = orientation;
    }

    public Edge(Edge e) {
        this(e.getFromName(), e.getToName(), e.getConf(), e.getType(), e.getOrientation());
    }

    public Edge(String n1, String n2, Integer type, Float conf, Double orientation) {
        this(n1, n2, type, orientation, conf);
    }

    public Edge(String n1, String n2, int type, float conf, double orientation) {
        this(n1, n2, conf, type, orientation);
    }

    public Edge(String n1, String n2) {
        this(n1, n2, 1.0f, 1);
    }

    public Edge(String n1, String n2, int type) {
        this(n1, n2, 1.0f, type);
    }

    public Edge(String n1, String n2, float conf) {
        this(n1, n2, conf, 1);
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setConf(float conf) {
        this.conf = conf;
    }

    public float getConf() {
        return this.conf;
    }

    public Node getComplement(String name) {
        if (this.n1.compareTo(name) == 0) {
            return new Node(this.n2);
        }
        if (this.n2.compareTo(name) == 0) {
            return new Node(this.n1);
        }
        return null;
    }

    public Node getComplement(Node n) {
        return this.getComplement(n.getLabel());
    }

    public boolean equals(Object o) {
        if (o.getClass() == this.getClass()) {
            Edge e = (Edge)o;
            return this.sameName(o) && this.type == e.type;
        }
        return this.sameName(o);
    }

    public String toString() {
        String result = this.n1 + "---" + this.n2;
        return result;
    }

    @Override
    public String report() {
        return super.report() + "\ti " + this.type + "\tc " + this.conf + "\to " + this.orientation;
    }

    public boolean containsNode(Node n) {
        String name = n.getLabel();
        if (name.compareTo(this.n1) == 0) {
            return true;
        }
        return name.compareTo(this.n2) == 0;
    }

    public void setOrientation(double orientation) {
        this.orientation = orientation;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public void renameNode(String oldName, String newName) {
        if (this.n1.compareTo(oldName) == 0) {
            this.n1 = newName;
        }
        if (this.n2.compareTo(oldName) == 0) {
            this.n2 = newName;
        }
    }
}

