/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.enhanced_mcl;

import java.util.Vector;
import medusa.georgios.enhanced_mcl.AbstractSimilarity;
import medusa.georgios.enhanced_mcl.Clusterer;
import medusa.georgios.enhanced_mcl.Dataset;
import medusa.georgios.enhanced_mcl.DefaultDataset;
import medusa.georgios.enhanced_mcl.DistanceMeasure;
import medusa.georgios.enhanced_mcl.Instance;
import medusa.georgios.enhanced_mcl.MarkovClustering;
import medusa.georgios.enhanced_mcl.SparseMatrix;

public class MCL
implements Clusterer {
    private DistanceMeasure dm;
    private double maxResidual = 0.001;
    private double pGamma = 2.0;
    private double loopGain = 0.0;
    private double maxZero = 0.001;

    public MCL(DistanceMeasure dm) {
        this(dm, 0.001, 2.0, 0.0, 0.001);
    }

    public MCL(DistanceMeasure dm, double maxResidual, double pGamma, double loopGain, double maxZero) {
        if (!(dm instanceof AbstractSimilarity)) {
            throw new RuntimeException("MCL requires the distance measure to be a Similarity measure");
        }
        this.dm = dm;
        this.maxResidual = maxResidual;
        this.pGamma = pGamma;
        this.loopGain = loopGain;
        this.maxZero = maxZero;
    }

    @Override
    public Dataset[] cluster(Dataset data) {
        int i;
        SparseMatrix dataSparseMatrix = new SparseMatrix();
        for (int i2 = 0; i2 < data.size(); ++i2) {
            for (int j = 0; j <= i2; ++j) {
                Instance y;
                Instance x = data.instance(i2);
                double dist = this.dm.measure(x, y = data.instance(j));
                if (!(dist > this.maxZero)) continue;
                dataSparseMatrix.add(i2, j, this.dm.measure(x, y));
            }
        }
        MarkovClustering mcl = new MarkovClustering();
        SparseMatrix matrix = mcl.run(dataSparseMatrix, this.maxResidual, this.pGamma, this.loopGain, this.maxZero);
        int[] sparseMatrixSize = matrix.getSize();
        int attractors = 0;
        for (int i3 = 0; i3 < sparseMatrixSize[0]; ++i3) {
            double val = matrix.get(i3, i3);
            if (val == 0.0) continue;
            ++attractors;
        }
        Vector finalClusters = new Vector();
        for (int i4 = 0; i4 < sparseMatrixSize[0]; ++i4) {
            Vector<Instance> cluster2 = new Vector<Instance>();
            double val = matrix.get(i4, i4);
            if (!(val >= 0.98)) continue;
            for (int j = 0; j < sparseMatrixSize[0]; ++j) {
                double value = matrix.get(j, i4);
                if (value == 0.0) continue;
                cluster2.add(data.instance(j));
            }
            finalClusters.add(cluster2);
        }
        Dataset[] output = new Dataset[finalClusters.size()];
        for (i = 0; i < finalClusters.size(); ++i) {
            output[i] = new DefaultDataset();
        }
        for (i = 0; i < finalClusters.size(); ++i) {
            Vector getCluster = new Vector();
            getCluster = (Vector)finalClusters.get(i);
            for (int j = 0; j < getCluster.size(); ++j) {
                output[i].add((Instance)getCluster.get(j));
            }
        }
        return output;
    }
}

