/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.Layouts;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import medusa.MedusaSimplerFrame;
import medusa.georgios.ClusteringAlgorithms.Affinity_Propagation;
import medusa.georgios.ClusteringAlgorithms.KMeans2;
import medusa.georgios.ClusteringAlgorithms.List2Graph;
import medusa.georgios.ClusteringAlgorithms.LoadClusters.LoadClusters;
import medusa.georgios.Distance_Geometry.DistanceGeometry;
import medusa.georgios.Layouts.GeneOntologyLayoutNode;
import medusa.georgios.Layouts.Point3d_VectorNormalization;
import medusa.georgios.color_factory.ColorFactory;
import medusa.georgios.enhanced_mcl.My_MarkovClustering;
import medusa.georgios.vecmathpackage.Color3f;
import medusa.georgios.vecmathpackage.Point3d;
import medusa.graph.BasicGraph;
import medusa.graph.Edge;
import medusa.graph.Graph;
import medusa.graph.Node;

public class Layouts
extends MedusaSimplerFrame {
    public static LoadClusters cl;
    private static ArrayList<Node> final_Order_of_Nodes;
    private static ArrayList<String> Used_Nodes;
    public static Affinity_Propagation affinity_propagation_clustering;
    public static My_MarkovClustering markov_clustering;
    public static KMeans2 kmeans;
    public static String affinity_propagation_report;
    public static String markov_clustering_report;
    static ArrayList<Node> tmp;
    static int distance;

    private static int yes_no(String message) {
        int s = JOptionPane.showConfirmDialog(MedusaSimplerFrame.stringletPanel, message, "", 0);
        return s;
    }

    private static int Calculate_distances_of_nodes(Node node, Graph g) {
        distance = 0;
        tmp.clear();
        Layouts.GiveNode_take_distance(node, g);
        return distance;
    }

    private static void GiveNode_take_distance(Node node, Graph g) {
        if (!Used_Nodes.contains(node.getLabel())) {
            Used_Nodes.add(node.getLabel());
            final_Order_of_Nodes.add(node);
        }
        if (tmp.size() <= g.getNodeSize() && node.getConnections() != 0) {
            int i = 0;
            Iterator<Edge> it = g.edgesIterator();
            while (it.hasNext()) {
                Edge e = it.next();
                String source = e.getFromName();
                String destination = e.getToName();
                if (source.compareToIgnoreCase(node.getLabel()) != 0) continue;
                if (!tmp.contains(g.getNode(destination))) {
                    ++distance;
                    tmp.add(g.getNode(destination));
                    if (!Used_Nodes.contains(destination)) {
                        Used_Nodes.add(destination);
                        final_Order_of_Nodes.add(g.getNode(destination));
                    }
                    Layouts.GiveNode_take_distance(g.getNode(destination), g);
                }
                ++i;
            }
        }
    }

    public static void Apply_GO_like_Coordinates(Graph g, Component screen) {
        if (g.getNodeSize() > 1) {
            int i;
            boolean isSorted;
            double z = 0.0;
            ArrayList coor = new ArrayList();
            boolean counter = false;
            final_Order_of_Nodes.clear();
            Used_Nodes.clear();
            int number_of_points = g.getNodeSize();
            ArrayList<Point3d> point_set = new ArrayList<Point3d>();
            ArrayList<String> Order_of_Nodes = new ArrayList<String>();
            ArrayList<Integer> Children_of_Nodes = new ArrayList<Integer>();
            Hashtable<String, GeneOntologyLayoutNode> GiveInternalNameGetGeneOntologyLayoutNode = new Hashtable<String, GeneOntologyLayoutNode>();
            int number_of_levels_for_GO = 0;
            int counteri = 0;
            Iterator<Node> it = g.nodesIterator();
            while (it.hasNext()) {
                Node node = it.next();
                GeneOntologyLayoutNode nnn = new GeneOntologyLayoutNode(node, Layouts.Calculate_distances_of_nodes(node, g), g);
                Order_of_Nodes.add(node.getLabel());
                Children_of_Nodes.add(nnn.distance);
                GiveInternalNameGetGeneOntologyLayoutNode.put(node.getLabel(), nnn);
                ++counteri;
            }
            int numberOfTimesLooped = 0;
            do {
                isSorted = true;
                for (i = 1; i < Order_of_Nodes.size() - numberOfTimesLooped; ++i) {
                    if ((Integer)Children_of_Nodes.get(i) >= (Integer)Children_of_Nodes.get(i - 1)) continue;
                    int tempVariable = (Integer)Children_of_Nodes.get(i);
                    Children_of_Nodes.set(i, (Integer)Children_of_Nodes.get(i - 1));
                    Children_of_Nodes.set(i - 1, tempVariable);
                    String tmp_vertice = (String)Order_of_Nodes.get(i);
                    Order_of_Nodes.set(i, (String)Order_of_Nodes.get(i - 1));
                    Order_of_Nodes.set(i - 1, tmp_vertice);
                    isSorted = false;
                }
                ++numberOfTimesLooped;
            } while (!isSorted);
            for (i = Order_of_Nodes.size() - 1; i >= 0; --i) {
                GeneOntologyLayoutNode n1 = (GeneOntologyLayoutNode)GiveInternalNameGetGeneOntologyLayoutNode.get(Order_of_Nodes.get(i));
                if (n1 == null) continue;
                int ccc = 0;
                Iterator<Edge> it2 = g.edgesIterator();
                while (it2.hasNext()) {
                    Edge e = it2.next();
                    String source = e.getFromName();
                    String destination = e.getToName();
                    if (source.compareToIgnoreCase(n1.node.getLabel()) != 0) continue;
                    ++ccc;
                }
                if (ccc == 0) continue;
                int j = 0;
                Iterator<Edge> it3 = g.edgesIterator();
                while (it3.hasNext()) {
                    Node mm;
                    GeneOntologyLayoutNode n2;
                    Edge e = it3.next();
                    String source = e.getFromName();
                    String destination = e.getToName();
                    if (source.compareToIgnoreCase(n1.node.getLabel()) == 0 && (n2 = (GeneOntologyLayoutNode)GiveInternalNameGetGeneOntologyLayoutNode.get((mm = g.getNode(e.getFromName())).getLabel())) != null) {
                        n2.level = n1.level + 1;
                        number_of_levels_for_GO = Math.max(number_of_levels_for_GO, n2.level);
                    }
                    ++j;
                }
            }
            ++number_of_levels_for_GO;
            Node Node2 = null;
            try {
                int i2;
                double start_y = screen.getHeight() - 15;
                double step_y = screen.getHeight() / (number_of_levels_for_GO + 1);
                double pos_tmp = 0.0;
                for (int n = 0; n < number_of_levels_for_GO; ++n) {
                    double start_x;
                    double pos_x = start_x = 15.0;
                    double pos_y = start_y;
                    ArrayList<Node> semi_final_Order_of_Nodes = new ArrayList<Node>();
                    for (int j = 0; j < final_Order_of_Nodes.size(); ++j) {
                        GeneOntologyLayoutNode m = (GeneOntologyLayoutNode)GiveInternalNameGetGeneOntologyLayoutNode.get(final_Order_of_Nodes.get(j).getLabel());
                        if (m.level != n) continue;
                        semi_final_Order_of_Nodes.add(final_Order_of_Nodes.get(j));
                    }
                    double step_x = screen.getWidth() / (semi_final_Order_of_Nodes.size() + 1);
                    for (int i3 = 0; i3 < semi_final_Order_of_Nodes.size(); ++i3) {
                        Point3d p;
                        Node2 = (Node)semi_final_Order_of_Nodes.get(i3);
                        GeneOntologyLayoutNode nn = (GeneOntologyLayoutNode)GiveInternalNameGetGeneOntologyLayoutNode.get(Node2.getLabel());
                        pos_x = start_x + (double)(i3 + 1) * step_x;
                        pos_y = start_y - step_y * (double)(number_of_levels_for_GO / (n + 1));
                        pos_y = start_y - step_y * (double)(n + 1);
                        double zz = 0.0;
                        if (semi_final_Order_of_Nodes.size() >= 60 && i3 % 2 == 0) {
                            zz += 1.5;
                        }
                        nn.p = p = new Point3d(pos_x, pos_y, zz);
                    }
                }
                for (i2 = 0; i2 < final_Order_of_Nodes.size(); ++i2) {
                    GeneOntologyLayoutNode nn = (GeneOntologyLayoutNode)GiveInternalNameGetGeneOntologyLayoutNode.get(final_Order_of_Nodes.get(i2).getLabel());
                    point_set.add(nn.p);
                }
                for (i2 = 0; i2 < final_Order_of_Nodes.size(); ++i2) {
                    Node2 = final_Order_of_Nodes.get(i2);
                    if (Node2 == null) continue;
                    Node2.setX(((Point3d)point_set.get((int)i2)).x);
                    Node2.setY(((Point3d)point_set.get((int)i2)).y);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void Apply_Distance_Geomretry_Coordinates(Graph g, Component screen) {
        if (g.getNodeSize() > 1) {
            try {
                ArrayList normalized_point_set = new ArrayList();
                ArrayList<Point3d> point_set = new ArrayList();
                int number_of_points = g.getNodeSize();
                int number_of_connections = g.getEdges().size();
                ArrayList<String> clustering_connections = new ArrayList<String>();
                Iterator<Edge> it = g.edgesIterator();
                while (it.hasNext()) {
                    Edge e = it.next();
                    String source = e.getFromName();
                    String destination = e.getToName();
                    clustering_connections.add(source + "\t" + destination + "\t" + e.getConf());
                }
                List2Graph gg = new List2Graph(clustering_connections);
                int elements = List2Graph.labels.size();
                DistanceGeometry DG = new DistanceGeometry();
                point_set = DG.distribute_nodes(gg.return_double_matrix());
                Point3d_VectorNormalization coordinates = new Point3d_VectorNormalization(point_set, 15.0, (double)(Math.min(screen.getWidth() - 1, screen.getHeight() - 1) - 15));
                normalized_point_set = coordinates.Return_Normalized_Vector();
                int counteri = 0;
                Iterator<Node> it2 = g.nodesIterator();
                while (it2.hasNext()) {
                    Node node = it2.next();
                    node.setX(((Point3d)normalized_point_set.get((int)counteri)).x);
                    node.setY(((Point3d)normalized_point_set.get((int)counteri)).y);
                    ++counteri;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ArrayList<Point3d> Apply_Circular_Coordinates(Graph g, Component screen) {
        if (g.getNodeSize() > 1) {
            ArrayList<Point3d> point_set = new ArrayList<Point3d>();
            try {
                if (g.getNodeSize() >= 2) {
                    double R = Math.min(screen.getWidth() - 1, screen.getHeight() - 1) / 2 - 10;
                    double Xc = screen.getWidth() / 2;
                    double Yc = screen.getHeight() / 2;
                    double Zc = 0.0;
                    double x = screen.getWidth() / 2;
                    double y = screen.getHeight() / 2;
                    double z = 0.0;
                    double Du = 0.0;
                    double[][] ctrlpoints = new double[g.getNodeSize()][3];
                    double angle_step = 360.0f / (float)(g.getNodeSize() + 1);
                    for (int i = 0; i < g.getNodeSize(); ++i) {
                        x = Xc + R * (double)((float)Math.cos(Math.toRadians(Du)));
                        y = Yc + R * (double)((float)Math.sin(Math.toRadians(Du)));
                        z = 0.0;
                        ctrlpoints[i][0] = x;
                        ctrlpoints[i][1] = y;
                        ctrlpoints[i][2] = z;
                        Du += angle_step;
                        double CurX = ctrlpoints[i][0];
                        double CurY = ctrlpoints[i][1];
                        Point3d p = new Point3d(CurX, CurY, 0.0);
                        point_set.add(p);
                    }
                    int counteri = 0;
                    Iterator<Node> it = g.nodesIterator();
                    while (it.hasNext()) {
                        Node node = it.next();
                        node.setX(point_set.get((int)counteri).x);
                        node.setY(point_set.get((int)counteri).y);
                        ++counteri;
                    }
                }
                System.gc();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return point_set;
        }
        return null;
    }

    public static int spread_to_grid(int n) {
        int result = 0;
        int i = 0;
        double x = n;
        while (i >= 0) {
            if (++i * i < n) continue;
            result = i;
            break;
        }
        return result;
    }

    public static void Apply_Grid_Coordinates(Graph g, Component screen) {
        if (g.getNodeSize() > 1) {
            Point3d point;
            double coory;
            double coorx;
            double z = 0.0;
            ArrayList<Point3d> coor = new ArrayList<Point3d>();
            boolean counter = false;
            float distance_between_points = 0.0f;
            int number_of_points = g.getNodeSize();
            float number_of_points_per_line = 0.0f;
            number_of_points_per_line = number_of_points % 2 == 0 ? (float)Layouts.spread_to_grid(number_of_points + 1) : (float)Layouts.spread_to_grid(number_of_points);
            distance_between_points = number_of_points_per_line;
            float temp_width = Math.min((float)screen.getWidth() * 0.9f, (float)screen.getWidth() * 0.9f);
            distance_between_points = temp_width / (number_of_points_per_line - 1.0f);
            if (distance_between_points == 0.0f) {
                distance_between_points = 0.001f;
            }
            System.out.println("distance_between_points:" + distance_between_points);
            float start_x = 15.0f;
            float start_y = 15.0f;
            double coorz = 0.0;
            if (number_of_points_per_line == 1.0f) {
                coorx = 0.0;
                coory = 0.0;
                point = new Point3d(coorx, coory, coorz);
                coor.add(point);
            } else {
                for (float y = 0.0f; y < number_of_points_per_line; y += 1.0f) {
                    start_x = 15.0f;
                    for (float x = 0.0f; x < number_of_points_per_line; x += 1.0f) {
                        if (coor.size() >= number_of_points) continue;
                        coorx = start_x + x * distance_between_points;
                        coory = start_y + y * distance_between_points;
                        point = new Point3d(coorx, coory, coorz);
                        coor.add(point);
                    }
                }
            }
            int counteri = 0;
            Iterator<Node> it = g.nodesIterator();
            while (it.hasNext()) {
                Node node = it.next();
                node.setX(((Point3d)coor.get((int)counteri)).x);
                node.setY(((Point3d)coor.get((int)counteri)).y);
                ++counteri;
            }
        }
    }

    public static boolean Initialize_Kmeans(BasicGraph gg, int nclusters) {
        try {
            cl = null;
            ArrayList<String> clustering_connections = new ArrayList<String>();
            boolean is_ready_to_run = true;
            int number_of_points = gg.getNodeSize();
            int number_of_connections = gg.getEdges().size();
            Iterator<Edge> it = gg.edgesIterator();
            while (it.hasNext()) {
                Edge e = it.next();
                String source = gg.getNode(e.getFromName()).getLabel();
                String destination = gg.getNode(e.getToName()).getLabel();
                clustering_connections.add(source + "\t" + destination + "\t" + e.getConf());
            }
            String expr = Integer.toString(nclusters);
            if (nclusters <= 0) {
                expr = JOptionPane.showInputDialog(MedusaSimplerFrame.stringletPanel, (Object)"Enter number of clusters");
            }
            if (expr.matches("[0-9]+")) {
                int num_of_clusters = Integer.parseInt(expr);
                System.out.println("Running Kmeans");
                List2Graph g = new List2Graph(clustering_connections);
                kmeans = new KMeans2(num_of_clusters, gg);
                if (num_of_clusters < List2Graph.labels.size()) {
                    kmeans.runKMeans();
                    System.out.println(kmeans.getReport());
                    kmeans.Save_To_File("Kmeans_clustering" + num_of_clusters + ".txt", kmeans.getReport());
                    System.out.println("Kmeans results was saved in Kmeans_clustering" + num_of_clusters + ".txt");
                    is_ready_to_run = true;
                } else {
                    JOptionPane.showMessageDialog(MedusaSimplerFrame.stringletPanel, "User must enter a number of clusters below " + List2Graph.labels.size());
                    is_ready_to_run = false;
                }
            } else {
                JOptionPane.showMessageDialog(MedusaSimplerFrame.stringletPanel, "User must enter a number.");
                is_ready_to_run = false;
            }
            return is_ready_to_run;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void Initialize_MarkovClustering(Graph gg, Component screen) {
        ArrayList<String> clustering_connections = new ArrayList<String>();
        cl = null;
        int number_of_points = gg.getNodeSize();
        int number_of_connections = gg.getEdges().size();
        Iterator<Edge> it = gg.edgesIterator();
        while (it.hasNext()) {
            Edge e = it.next();
            String source = gg.getNode(e.getFromName()).getLabel();
            String destination = gg.getNode(e.getToName()).getLabel();
            clustering_connections.add(source + "\t" + destination + "\t" + e.getConf());
        }
        System.out.println("Running Markov Clustering");
        markov_clustering = new My_MarkovClustering(clustering_connections);
        if (screen == stringletPanel) {
            System.out.println(markov_clustering.Save_To_File("MCL.txt", true));
            System.out.println("Markov Clustering results were saved in  MCL.txt");
        } else {
            System.out.println(markov_clustering.Save_To_File("MCL.txt", false));
        }
    }

    public static void Apply_Kmeans_Clustering(Graph g, Component screen) {
        Layouts.Apply_Kmeans_Clustering(g, screen, 0);
    }

    public static void Apply_Kmeans_Clustering(Graph g, Component screen, int nclusters) {
        cl = null;
        if (g.getNodeSize() > 1) {
            try {
                int number_of_points = g.getNodeSize();
                int number_of_connections = g.getEdges().size();
                boolean ik = Layouts.Initialize_Kmeans(g, nclusters);
                if (Layouts.Initialize_Kmeans(g, nclusters)) {
                    Map<String, Integer> nodes_clusters = kmeans.getClusterMap();
                    cl = new LoadClusters(kmeans.getReport());
                    Layouts.distribute_clusters(g, screen);
                    if (screen == stringletPanel) {
                        System.out.println(kmeans.Save_To_File("kmeans" + kmeans.getK() + ".txt"));
                        System.out.println("kmeans results was saved in kmeans" + kmeans.getK() + ".txt");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void Apply_MCL_Propagation_Clustering(Graph gg, Component screen) {
        if (gg.getNodeSize() > 1) {
            try {
                int number_of_points = gg.getNodeSize();
                int number_of_connections = gg.getEdges().size();
                Layouts.Initialize_MarkovClustering(gg, screen);
                markov_clustering_report = markov_clustering.getReport();
                cl = new LoadClusters(markov_clustering_report);
                Layouts.distribute_clusters(gg, screen);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void Initialize_AffinityPropagation(Graph g, Component screen) {
        ArrayList<String> clustering_connections = new ArrayList<String>();
        int number_of_points = g.getNodeSize();
        int number_of_connections = g.getEdges().size();
        Iterator<Edge> it = g.edgesIterator();
        while (it.hasNext()) {
            Edge e = it.next();
            String source = g.getNode(e.getFromName()).getLabel();
            String destination = g.getNode(e.getToName()).getLabel();
            clustering_connections.add(source + "\t" + destination + "\t" + e.getConf());
        }
        System.out.println("Running Affinity Propagation");
        affinity_propagation_clustering = new Affinity_Propagation(clustering_connections);
        System.out.println("Number of clusters=" + affinity_propagation_clustering.getNumberOfClusters());
        if (screen == stringletPanel) {
            System.out.println(affinity_propagation_clustering.Save_To_File("Affinity_Propagation.txt"));
            System.out.println("Affinity Propagation results was saved in  Affinity_Propagation.txt");
        }
    }

    public static void Apply_Random_Coordinates(Graph g, Component screen) {
        if (g.getNodeSize() > 1) {
            Iterator<Node> it = g.nodesIterator();
            while (it.hasNext()) {
                Node node = it.next();
                node.setX(Math.random() * (double)screen.getWidth());
                node.setY(Math.random() * (double)screen.getHeight());
            }
        }
        screen.repaint();
    }

    public static void Apply_Affinity_Propagation_Clustering(Graph g, Component screen) {
        if (g.getNodeSize() > 1) {
            try {
                int number_of_points = g.getNodeSize();
                int number_of_connections = g.getEdges().size();
                Layouts.Initialize_AffinityPropagation(g, screen);
                affinity_propagation_report = affinity_propagation_clustering.getReport();
                cl = new LoadClusters(affinity_propagation_clustering.getReport());
                Layouts.distribute_clusters(g, screen);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void Apply_Predefined_Clustering(Graph gg, Component screen) {
        if (gg.getNodeSize() > 1) {
            try {
                int number_of_points = gg.getNodeSize();
                int number_of_connections = gg.getEdges().size();
                ArrayList<Integer> Clusters = new ArrayList<Integer>();
                Iterator<Node> it = gg.nodesIterator();
                while (it.hasNext()) {
                    Node node = it.next();
                    if (Clusters.contains(node.getCLuster())) continue;
                    Clusters.add(node.getCLuster());
                }
                System.out.println("Predefined clusters: " + Clusters.size());
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < Clusters.size(); ++i) {
                    str.append("----------------- Cluster: " + (i + 1) + " -----------------\n");
                    Iterator<Node> it2 = gg.nodesIterator();
                    while (it2.hasNext()) {
                        Node node = it2.next();
                        if (((Integer)Clusters.get(i)).intValue() != node.getCLuster()) continue;
                        str.append(node.getLabel() + "\n");
                    }
                    System.out.println("~~~~~" + str.toString());
                    cl = new LoadClusters(str.toString());
                    Layouts.distribute_clusters(gg, screen);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void distribute_clusters(Graph g, Component screen) {
        block28: {
            if (screen == MedusaSimplerFrame.stringletPanel) {
                MedusaSimplerFrame.setNodeColorSet(4);
                channel1MenuItem.setSelected(false);
                channel2MenuItem.setSelected(false);
                channel3MenuItem.setSelected(false);
                jRadioButtonMenuItem1.setSelected(true);
            }
            if (g.getNodeSize() > 1) {
                try {
                    int number_of_points = g.getNodeSize();
                    int number_of_connections = g.getEdges().size();
                    ArrayList<Point3d> centers = new ArrayList<Point3d>();
                    System.out.println("Number of clusters:" + cl.number_of_clusters());
                    ArrayList<Point3d> point_set = new ArrayList<Point3d>();
                    ArrayList<Color> colorscheme = new ArrayList<Color>();
                    ColorFactory cc = new ColorFactory();
                    colorscheme.add(Color.RED);
                    colorscheme.add(Color.GREEN);
                    colorscheme.add(Color.BLUE);
                    colorscheme.add(Color.PINK);
                    colorscheme.add(Color.LIGHT_GRAY);
                    colorscheme.add(Color.ORANGE);
                    colorscheme.add(Color.CYAN);
                    colorscheme.add(Color.MAGENTA);
                    for (int i = 0; i <= cl.number_of_clusters(); ++i) {
                        Integer object = new Integer(i);
                        Color3f color = cc.computeColor(object, 1.0f);
                        int red = (int)(color.x * 255.0f);
                        int green = (int)(color.y * 255.0f);
                        int blue = (int)(color.z * 255.0f);
                        if (red <= 0) {
                            red = 0;
                        }
                        if (red >= 255) {
                            red = 255;
                        }
                        if (green <= 0) {
                            green = 0;
                        }
                        if (green >= 255) {
                            green = 255;
                        }
                        if (blue <= 0) {
                            blue = 0;
                        }
                        if (blue >= 255) {
                            blue = 255;
                        }
                        Color c = new Color(red, green, blue);
                        colorscheme.add(c);
                    }
                    float number_of_centers_per_line = 0.0f;
                    number_of_centers_per_line = number_of_points % 2 == 0 ? (float)Layouts.spread_to_grid(cl.number_of_clusters() + 1) : (float)Layouts.spread_to_grid(cl.number_of_clusters());
                    float distance_between_points = number_of_centers_per_line;
                    float temp_width = (float)Math.min(screen.getWidth() - 1, screen.getHeight() - 1) * 0.9f;
                    distance_between_points = temp_width / (number_of_centers_per_line - 1.0f);
                    if (distance_between_points == 0.0f) {
                        distance_between_points = 0.001f;
                    }
                    float start_x = 15.0f;
                    float start_y = 15.0f;
                    double coorz = 0.0;
                    if (number_of_centers_per_line == 1.0f) {
                        double coorx = 0.0;
                        double coory = 0.0;
                        Point3d point = new Point3d(coorx, coory, coorz);
                        centers.add(point);
                    } else {
                        int y = 0;
                        while ((float)y < number_of_centers_per_line) {
                            start_x = 15.0f;
                            int x = 0;
                            while ((float)x < number_of_centers_per_line) {
                                if (centers.size() < number_of_points) {
                                    double coorx = start_x + (float)x * distance_between_points;
                                    double coory = start_y + (float)y * distance_between_points;
                                    Point3d point = new Point3d(coorx, coory, coorz);
                                    centers.add(point);
                                }
                                ++x;
                            }
                            ++y;
                        }
                    }
                    if (cl.number_of_clusters() == 1) {
                        Layouts.Apply_Circular_Coordinates(g, screen);
                        for (int j = 0; j < Layouts.cl.list_with_clusters.get(0).number_of_nodes(); ++j) {
                            Node Node2 = g.getNode(Layouts.cl.list_with_clusters.get((int)0).node_names.get(j));
                            Node2.setClusteringColor((Color)colorscheme.get(0));
                        }
                        break block28;
                    }
                    for (int i = 0; i < cl.number_of_clusters(); ++i) {
                        point_set.clear();
                        if (Layouts.cl.list_with_clusters.get(i).number_of_nodes() >= 2) {
                            double R = (distance_between_points - 1.0f) / 2.0f - 10.0f;
                            if (Layouts.cl.list_with_clusters.get(i).number_of_nodes() <= 10 && R >= 40.0 && cl.number_of_clusters() <= 15) {
                                R = 40.0;
                            }
                            double Xc = ((Point3d)centers.get((int)i)).x + R / 2.0;
                            double Yc = ((Point3d)centers.get((int)i)).y + R / 2.0;
                            double Zc = 0.0;
                            double x = Xc;
                            double y = Yc + R;
                            double z = 0.0;
                            double Du = 0.0;
                            double[][] ctrlpoints = new double[Layouts.cl.list_with_clusters.get(i).number_of_nodes()][3];
                            double angle_step = 360.0f / (float)(Layouts.cl.list_with_clusters.get(i).number_of_nodes() + 1);
                            for (int ii = 0; ii < Layouts.cl.list_with_clusters.get(i).number_of_nodes(); ++ii) {
                                x = Xc + R * (double)((float)Math.cos(Math.toRadians(Du)));
                                y = Yc + R * (double)((float)Math.sin(Math.toRadians(Du)));
                                z = 0.0;
                                ctrlpoints[ii][0] = x;
                                ctrlpoints[ii][1] = y;
                                ctrlpoints[ii][2] = z;
                                Du += angle_step;
                                double CurX = ctrlpoints[ii][0];
                                double CurY = ctrlpoints[ii][1];
                                if (CurY <= 0.0) {
                                    CurY = 10.0;
                                }
                                if (CurY >= (double)screen.getHeight()) {
                                    CurY = screen.getHeight() - 10;
                                }
                                if (CurX <= 0.0) {
                                    CurX = 10.0;
                                }
                                if (CurX >= (double)screen.getWidth()) {
                                    CurX = screen.getWidth() - 10;
                                }
                                CurX = Math.random() >= 0.5 ? (CurX += Math.random()) : (CurX -= Math.random());
                                CurY = Math.random() >= 0.5 ? (CurY += Math.random()) : (CurY -= Math.random());
                                Point3d p = new Point3d(CurX, CurY, 0.0);
                                point_set.add(p);
                            }
                            for (int j = 0; j < Layouts.cl.list_with_clusters.get(i).number_of_nodes(); ++j) {
                                Node Node3 = g.getNode(Layouts.cl.list_with_clusters.get((int)i).node_names.get(j));
                                Node3.setX(((Point3d)point_set.get((int)j)).x);
                                Node3.setY(((Point3d)point_set.get((int)j)).y);
                                Node3.setClusteringColor((Color)colorscheme.get(i));
                            }
                            continue;
                        }
                        if (Layouts.cl.list_with_clusters.get(i).number_of_nodes() <= 0) continue;
                        Node Node4 = g.getNode(Layouts.cl.list_with_clusters.get((int)i).node_names.get(0));
                        Node4.setX(((Point3d)centers.get((int)i)).x);
                        Node4.setY(((Point3d)centers.get((int)i)).y);
                        Node4.setClusteringColor((Color)colorscheme.get(i));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        final_Order_of_Nodes = new ArrayList();
        Used_Nodes = new ArrayList();
        affinity_propagation_report = null;
        markov_clustering_report = null;
        tmp = new ArrayList();
        distance = 0;
    }
}

