/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.ClusteringAlgorithms;

public final class My_Matrix {
    private final int M;
    private final int N;
    private final double[][] data;

    public My_Matrix(int M, int N) {
        this.M = M;
        this.N = N;
        this.data = new double[M][N];
    }

    public My_Matrix(double[][] data) {
        this.M = data.length;
        this.N = data[0].length;
        this.data = new double[this.M][this.N];
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                this.data[i][j] = data[i][j];
            }
        }
    }

    private My_Matrix(My_Matrix A) {
        this(A.data);
    }

    public static My_Matrix random(int M, int N) {
        My_Matrix A = new My_Matrix(M, N);
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < N; ++j) {
                A.data[i][j] = Math.random();
            }
        }
        return A;
    }

    public static My_Matrix copyMatrix(My_Matrix X) {
        My_Matrix A = new My_Matrix(X.M, X.N);
        for (int i = 0; i < X.M; ++i) {
            for (int j = 0; j < X.N; ++j) {
                A.data[i][j] = X.get_element(i, j);
            }
        }
        return A;
    }

    public static My_Matrix identity(int N) {
        My_Matrix I = new My_Matrix(N, N);
        for (int i = 0; i < N; ++i) {
            I.data[i][i] = 1.0;
        }
        return I;
    }

    public double get_element(int i, int j) {
        return this.data[i][j];
    }

    public void set_element(double value, int i, int j) {
        this.data[i][j] = value;
    }

    private void swap(int i, int j) {
        double[] temp = this.data[i];
        this.data[i] = this.data[j];
        this.data[j] = temp;
    }

    public My_Matrix transpose() {
        My_Matrix A = new My_Matrix(this.N, this.M);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                A.data[j][i] = this.data[i][j];
            }
        }
        return A;
    }

    public My_Matrix plus(My_Matrix B) {
        My_Matrix A = this;
        if (B.M != A.M || B.N != A.N) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        My_Matrix C = new My_Matrix(this.M, this.N);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                C.data[i][j] = A.data[i][j] + B.data[i][j];
            }
        }
        return C;
    }

    public My_Matrix minus(My_Matrix B) {
        My_Matrix A = this;
        if (B.M != A.M || B.N != A.N) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        My_Matrix C = new My_Matrix(this.M, this.N);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                C.data[i][j] = A.data[i][j] - B.data[i][j];
            }
        }
        return C;
    }

    public boolean eq(My_Matrix B) {
        My_Matrix A = this;
        if (B.M != A.M || B.N != A.N) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                if (A.data[i][j] == B.data[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public My_Matrix times(My_Matrix B) {
        My_Matrix A = this;
        if (A.N != B.M) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        My_Matrix C = new My_Matrix(A.M, B.N);
        for (int i = 0; i < C.M; ++i) {
            for (int j = 0; j < C.N; ++j) {
                for (int k = 0; k < A.N; ++k) {
                    double[] dArray = C.data[i];
                    int n = j;
                    dArray[n] = dArray[n] + A.data[i][k] * B.data[k][j];
                }
            }
        }
        return C;
    }

    public My_Matrix solve(My_Matrix rhs) {
        if (this.M != this.N || rhs.M != this.N || rhs.N != 1) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        My_Matrix A = new My_Matrix(this);
        My_Matrix b = new My_Matrix(rhs);
        for (int i = 0; i < this.N; ++i) {
            int j;
            int max = i;
            for (j = i + 1; j < this.N; ++j) {
                if (!(Math.abs(A.data[j][i]) > Math.abs(A.data[max][i]))) continue;
                max = j;
            }
            A.swap(i, max);
            b.swap(i, max);
            if (A.data[i][i] == 0.0) {
                throw new RuntimeException("Matrix is singular.");
            }
            for (j = i + 1; j < this.N; ++j) {
                double[] dArray = b.data[j];
                dArray[0] = dArray[0] - b.data[i][0] * A.data[j][i] / A.data[i][i];
            }
            for (j = i + 1; j < this.N; ++j) {
                double m = A.data[j][i] / A.data[i][i];
                for (int k = i + 1; k < this.N; ++k) {
                    double[] dArray = A.data[j];
                    int n = k;
                    dArray[n] = dArray[n] - A.data[i][k] * m;
                }
                A.data[j][i] = 0.0;
            }
        }
        My_Matrix x = new My_Matrix(this.N, 1);
        for (int j = this.N - 1; j >= 0; --j) {
            double t = 0.0;
            for (int k = j + 1; k < this.N; ++k) {
                t += A.data[j][k] * x.data[k][0];
            }
            x.data[j][0] = (b.data[j][0] - t) / A.data[j][j];
        }
        return x;
    }

    public void show() {
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                System.out.printf("%9.4f ", this.data[i][j]);
            }
            System.out.println();
        }
        System.out.println("");
    }

    public static void main(String[] args) {
        double[][] d = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {9.0, 1.0, 3.0}};
        My_Matrix D = new My_Matrix(d);
        D.show();
        System.out.println();
        My_Matrix A = My_Matrix.random(5, 5);
        A.show();
        System.out.println();
        A.swap(1, 2);
        A.show();
        System.out.println();
        My_Matrix B = A.transpose();
        B.show();
        System.out.println();
        My_Matrix C = My_Matrix.identity(5);
        C.show();
        System.out.println();
        A.plus(B).show();
        System.out.println();
        B.times(A).show();
        System.out.println();
        System.out.println(A.times(B).eq(B.times(A)));
        System.out.println();
        My_Matrix b = My_Matrix.random(5, 1);
        b.show();
        System.out.println();
        My_Matrix x = A.solve(b);
        x.show();
        System.out.println();
        A.times(x).show();
    }
}

