/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.ClusteringAlgorithms;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import medusa.DemoTools;
import medusa.georgios.ClusteringAlgorithms.KMeansPoint;
import medusa.georgios.ClusteringAlgorithms.cluster;
import medusa.graph.BasicGraph;
import medusa.graph.Edge;
import medusa.graph.Graph;
import medusa.graph.GraphMatrix;

public class KMeans2 {
    private int k;
    private cluster[] clusters;
    private int nIterations;
    private Vector kMeansPoints;
    private String inputFileName;

    public KMeans2(int k, String inputFileName) {
        this.k = k;
        this.inputFileName = inputFileName;
        this.clusters = new cluster[this.k];
        this.nIterations = 0;
        this.kMeansPoints = new Vector();
    }

    public KMeans2(int k, BasicGraph g) {
        this.k = k;
        GraphMatrix gm = new GraphMatrix(g);
        int size = g.getNodeSize();
        this.kMeansPoints = new Vector();
        for (int i = 0; i < size; ++i) {
            this.kMeansPoints.add(new KMeansPoint(gm.getLabelForIndex(i), gm.getRowForIndex(i)));
        }
        this.clusters = new cluster[this.k];
        this.nIterations = 0;
    }

    public KMeans2(int k, List kMeansPoints) {
        this.k = k;
        this.clusters = new cluster[this.k];
        this.nIterations = 0;
        this.kMeansPoints = new Vector(kMeansPoints);
    }

    public void readData() throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(this.inputFileName));
        String line = "";
        while ((line = in.readLine()) != null) {
            String[] result = line.split("\t");
            if (result.length != 3) continue;
            KMeansPoint dp = new KMeansPoint(result[0], Float.parseFloat(result[1]), Float.parseFloat(result[2]));
            dp.assignToCluster(0);
            this.kMeansPoints.add(dp);
        }
        in.close();
    }

    public void runKMeans() {
        KMeansPoint km = (KMeansPoint)this.kMeansPoints.elementAt(0);
        for (int i = 0; i < this.k; ++i) {
            this.clusters[i] = new cluster(i);
            this.clusters[i].setMean((KMeansPoint)this.kMeansPoints.get((int)(Math.random() * (double)this.kMeansPoints.size())));
        }
        do {
            Iterator i = this.kMeansPoints.iterator();
            while (i.hasNext()) {
                this.assignToCluster((KMeansPoint)i.next());
            }
            ++this.nIterations;
        } while (this.updateMeans(km.size()));
    }

    private void assignToCluster(KMeansPoint dp) {
        int currentCluster = dp.getClusterNumber();
        double minDistance = KMeansPoint.distance(dp, this.clusters[currentCluster].getMean());
        for (int i = 0; i < this.k; ++i) {
            double tdist = KMeansPoint.distance(dp, this.clusters[i].getMean());
            if (!(tdist < minDistance)) continue;
            minDistance = tdist;
            currentCluster = i;
        }
        dp.assignToCluster(currentCluster);
    }

    private boolean updateMeans(int dim) {
        boolean reply = false;
        double[] x = new double[this.k];
        double[] y = new double[this.k];
        float[][] centroid = new float[dim][this.k];
        int[] size = new int[this.k];
        KMeansPoint[] pastMeans = new KMeansPoint[this.k];
        for (int i = 0; i < this.k; ++i) {
            size[i] = 0;
            pastMeans[i] = this.clusters[i].getMean();
        }
        for (KMeansPoint dp : this.kMeansPoints) {
            int currentCluster = dp.getClusterNumber();
            for (int index = 0; index < dim; ++index) {
                float[] fArray = centroid[index];
                int n = currentCluster;
                fArray[n] = (float)((double)fArray[n] + dp.getCoordinate(index));
            }
            int n = currentCluster;
            size[n] = size[n] + 1;
        }
        for (int j = 0; j < this.k; ++j) {
            if (size[j] == 0) continue;
            double[] coords = new double[dim];
            for (int index = 0; index < dim; ++index) {
                float[] fArray = centroid[index];
                int n = j;
                fArray[n] = fArray[n] / (float)size[j];
                coords[index] = centroid[index][j];
            }
            KMeansPoint temp = new KMeansPoint("temp", coords);
            temp.assignToCluster(j);
            this.clusters[j].setMean(temp);
            if (KMeansPoint.distance(pastMeans[j], this.clusters[j].getMean()) == 0.0) continue;
            reply = true;
        }
        return reply;
    }

    public String Save_To_File(String filename) {
        try {
            System.out.println("General Information");
            BufferedWriter outp = new BufferedWriter(new FileWriter(filename));
            outp.append(this.getReport());
            outp.close();
            return this.getReport();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean updateMeansBackup() {
        boolean reply = false;
        double[] x = new double[this.k];
        double[] y = new double[this.k];
        int[] size = new int[this.k];
        KMeansPoint[] pastMeans = new KMeansPoint[this.k];
        for (int i = 0; i < this.k; ++i) {
            x[i] = 0.0;
            y[i] = 0.0;
            size[i] = 0;
            pastMeans[i] = this.clusters[i].getMean();
        }
        for (KMeansPoint dp : this.kMeansPoints) {
            int currentCluster;
            int n = currentCluster = dp.getClusterNumber();
            x[n] = x[n] + dp.getX();
            int n2 = currentCluster;
            y[n2] = y[n2] + dp.getY();
            int n3 = currentCluster;
            size[n3] = size[n3] + 1;
        }
        for (int j = 0; j < this.k; ++j) {
            if (size[j] == 0) continue;
            int n = j;
            x[n] = x[n] / (double)size[j];
            int n4 = j;
            y[n4] = y[n4] / (double)size[j];
            KMeansPoint temp = new KMeansPoint("temp", (float)x[j], (float)y[j]);
            temp.assignToCluster(j);
            this.clusters[j].setMean(temp);
            if (KMeansPoint.distance(pastMeans[j], this.clusters[j].getMean()) == 0.0) continue;
            reply = true;
        }
        return reply;
    }

    public int getK() {
        return this.k;
    }

    public cluster getCluster(int index) {
        return this.getCluster(index);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.kMeansPoints.size(); ++i) {
            sb.append(this.kMeansPoints.elementAt(i).toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public Vector getDataPoints() {
        return this.kMeansPoints;
    }

    public Map<String, Integer> getClusterMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.kMeansPoints.size(); ++i) {
            KMeansPoint km = (KMeansPoint)this.kMeansPoints.get(i);
            map.put(km.getLabel(), km.getClusterNumber());
        }
        return map;
    }

    public String getReport() {
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i <= this.k; ++i) {
            sb.append("----------------- Cluster: " + i + " -----------------\n");
            for (int point = 0; point < this.kMeansPoints.size(); ++point) {
                KMeansPoint kpoint = (KMeansPoint)this.kMeansPoints.get(point);
                if (kpoint.getClusterNumber() != i - 1) continue;
                sb.append(kpoint.getLabel());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public void Save_To_File(String filename, String information) {
        try {
            BufferedWriter outp = new BufferedWriter(new FileWriter(filename));
            outp.append(information);
            outp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getSmallestClusterSize() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.kMeansPoints.size(); ++i) {
            KMeansPoint km = (KMeansPoint)this.kMeansPoints.get(i);
            Integer cluster2 = km.getClusterNumber();
            Integer count = 1;
            if (map.containsKey(cluster2)) {
                count = (Integer)map.get(cluster2) + 1;
            }
            map.put(cluster2, count);
        }
        Integer min = Integer.MAX_VALUE;
        for (Integer count : map.values()) {
            if (min <= count) continue;
            min = count;
        }
        return min;
    }

    public static void main(String[] args) {
        DemoTools dt = new DemoTools();
        Graph g = new Graph();
        g.addEdge(new Edge("a", "b", 0.4f));
        g.addEdge(new Edge("c", "b", 0.8f));
        g.addEdge(new Edge("a", "c", 0.0f));
        KMeans2 km = new KMeans2(2, g);
        km.runKMeans();
        System.out.println(km.getReport());
        System.out.println(km);
    }
}

