/*
 * Decompiled with CFR 0.152.
 */
package medusa.georgios.ClusteringAlgorithms;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import medusa.georgios.ClusteringAlgorithms.Node;

public class HCL {
    static float[][] matrix;
    static ArrayList<String> labels;
    int INCREMENT;
    int x;
    int y;
    ArrayList<Integer> Stored_Nodes_Map = new ArrayList();
    Node Tree;
    float Infinite = -9999999.0f;

    public HCL(float[][] Matrix, ArrayList<String> labels) {
        int j;
        int i;
        matrix = Matrix;
        HCL.labels = labels;
        for (i = 0; i < Matrix.length; ++i) {
            for (j = i + 1; j < Matrix.length; ++j) {
                this.Infinite = Math.max(Matrix[i][j], this.Infinite);
            }
        }
        this.Infinite += 1.0f;
        for (i = 0; i < Matrix.length; ++i) {
            for (j = i + 1; j < Matrix.length; ++j) {
                if (Matrix[i][j] == 0.0f) {
                    Matrix[i][j] = this.Infinite;
                }
                Matrix[j][i] = Matrix[i][j];
            }
        }
        this.INCREMENT = labels.size();
        this.run_hierarchical_clustering();
    }

    void find_minimum() {
        int j;
        int i;
        float minimum = this.Infinite;
        for (i = 0; i < this.INCREMENT; ++i) {
            for (j = i + 1; j < this.INCREMENT; ++j) {
                if (!(matrix[i][j] <= minimum)) continue;
                minimum = matrix[i][j];
                this.x = i;
                this.y = j;
            }
        }
        for (i = 0; i < this.INCREMENT; ++i) {
            float f = Math.min(matrix[i][this.x], matrix[i][this.y]);
            HCL.matrix[i][this.x] = f;
            HCL.matrix[this.x][i] = f;
            if (matrix[this.x][i] == 0.0f) break;
        }
        for (i = 0; i < this.INCREMENT; ++i) {
            float f = Math.min(matrix[i][this.y], matrix[i][this.y]);
            HCL.matrix[i][this.y] = f;
            HCL.matrix[this.y][i] = f;
            if (matrix[this.y][i] == 0.0f) break;
        }
        for (j = 0; j < this.INCREMENT; ++j) {
            float f = Math.min(matrix[this.x][j], matrix[this.y][j]);
            HCL.matrix[this.x][j] = f;
            HCL.matrix[j][this.x] = f;
            if (matrix[j][this.x] == 0.0f) break;
        }
        j = 0;
        while (i < this.INCREMENT) {
            float f = Math.min(matrix[this.x][j], matrix[this.y][j]);
            HCL.matrix[j][this.y] = f;
            HCL.matrix[this.y][j] = f;
            if (matrix[this.y][j] == 0.0f) break;
            ++j;
        }
        float f = this.Infinite;
        HCL.matrix[this.y][this.x] = f;
        HCL.matrix[this.x][this.y] = f;
    }

    void print_matrix() {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                if (i <= j) {
                    System.out.print(matrix[i][j] + "\t\t");
                    continue;
                }
                System.out.print("\t\t");
            }
            System.out.println("");
        }
    }

    void run_hierarchical_clustering() {
        Node source_parent;
        Node destination_parent1;
        Node destination_parent2;
        Node node2;
        Node node1;
        int i;
        this.Tree = new Node(labels);
        int counter = 0;
        int tree_nodes = this.INCREMENT;
        int roots_found = 0;
        for (i = 0; i < this.INCREMENT; ++i) {
            this.Tree.create_node();
        }
        while (counter < this.INCREMENT) {
            this.find_minimum();
            if (!this.Stored_Nodes_Map.contains(this.x)) {
                this.Stored_Nodes_Map.add(this.x);
                ++counter;
            }
            if (!this.Stored_Nodes_Map.contains(this.y)) {
                this.Stored_Nodes_Map.add(this.y);
                ++counter;
            }
            node1 = this.Tree.Index_nodes_map.get(this.x);
            node2 = this.Tree.Index_nodes_map.get(this.y);
            this.Tree.search_higher_ancestor_of(node2);
            destination_parent2 = this.Tree.higher_parent;
            this.Tree.search_higher_ancestor_of(node1);
            destination_parent1 = this.Tree.higher_parent;
            if (destination_parent1.id == destination_parent2.id) continue;
            source_parent = this.Tree.create_node();
            ++tree_nodes;
            if (!this.Tree.connection_exists(source_parent, destination_parent1)) {
                this.Tree.connect(source_parent, destination_parent1);
            }
            if (this.Tree.connection_exists(source_parent, destination_parent2)) continue;
            this.Tree.connect(source_parent, destination_parent2);
        }
        this.find_minimum();
        node1 = this.Tree.Index_nodes_map.get(this.x);
        node2 = this.Tree.Index_nodes_map.get(this.y);
        this.Tree.search_higher_ancestor_of(node2);
        destination_parent2 = this.Tree.higher_parent;
        this.Tree.search_higher_ancestor_of(node1);
        destination_parent1 = this.Tree.higher_parent;
        if (destination_parent1.id != destination_parent2.id) {
            source_parent = this.Tree.create_node();
            ++tree_nodes;
            if (!this.Tree.connection_exists(source_parent, destination_parent1)) {
                this.Tree.connect(source_parent, destination_parent1);
            }
            if (!this.Tree.connection_exists(source_parent, destination_parent2)) {
                this.Tree.connect(source_parent, destination_parent2);
            }
        }
        do {
            roots_found = 0;
            for (i = 0; i < this.Tree.id_counter; ++i) {
                node1 = this.Tree.Index_nodes_map.get(i);
                if (node1.parent != null) continue;
                ++roots_found;
            }
            if (roots_found == true) continue;
            for (i = 0; i < this.Tree.id_counter; ++i) {
                node1 = this.Tree.Index_nodes_map.get(i);
                if (node1.parent == null) break;
            }
            for (i = 0; i < this.Tree.id_counter; ++i) {
                node2 = this.Tree.Index_nodes_map.get(i);
                if (node2.parent == null && node2.id != node1.id) break;
            }
            source_parent = this.Tree.create_node();
            ++tree_nodes;
            this.Tree.connect(source_parent, node1);
            this.Tree.connect(source_parent, node2);
        } while (roots_found != true);
    }

    public void Save_To_File(String filename, String information) {
        try {
            BufferedWriter outp = new BufferedWriter(new FileWriter(filename));
            outp.append(information);
            outp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String get_NewickFormat_HCL() {
        String str = this.Tree.get_tree_NewickFormat().toString().trim();
        return str;
    }

    public String get_NewickFormat_HCL(String layer) {
        String str = this.Tree.get_tree_NewickFormat().toString().trim();
        return str;
    }

    public static void main(String[] args) {
        labels = new ArrayList();
        labels.add("BA");
        labels.add("FI");
        labels.add("MI");
        labels.add("NA");
        labels.add("RM");
        labels.add("TO");
        matrix = new float[labels.size()][labels.size()];
        HCL.matrix[0][0] = 0.0f;
        HCL.matrix[0][1] = 662.0f;
        HCL.matrix[0][2] = 877.0f;
        HCL.matrix[0][3] = 255.0f;
        HCL.matrix[0][4] = 412.0f;
        HCL.matrix[0][5] = 996.0f;
        HCL.matrix[1][0] = 662.0f;
        HCL.matrix[1][1] = 0.0f;
        HCL.matrix[1][2] = 295.0f;
        HCL.matrix[1][3] = 468.0f;
        HCL.matrix[1][4] = 268.0f;
        HCL.matrix[1][5] = 400.0f;
        HCL.matrix[2][0] = 877.0f;
        HCL.matrix[2][1] = 295.0f;
        HCL.matrix[2][2] = 0.0f;
        HCL.matrix[2][3] = 754.0f;
        HCL.matrix[2][4] = 564.0f;
        HCL.matrix[2][5] = 138.0f;
        HCL.matrix[3][0] = 255.0f;
        HCL.matrix[3][1] = 468.0f;
        HCL.matrix[3][2] = 754.0f;
        HCL.matrix[3][3] = 0.0f;
        HCL.matrix[3][4] = 219.0f;
        HCL.matrix[3][5] = 869.0f;
        HCL.matrix[4][0] = 412.0f;
        HCL.matrix[4][1] = 268.0f;
        HCL.matrix[4][2] = 564.0f;
        HCL.matrix[4][3] = 219.0f;
        HCL.matrix[4][4] = 0.0f;
        HCL.matrix[4][5] = 669.0f;
        HCL.matrix[5][0] = 996.0f;
        HCL.matrix[5][1] = 400.0f;
        HCL.matrix[5][2] = 138.0f;
        HCL.matrix[5][3] = 869.0f;
        HCL.matrix[5][4] = 669.0f;
        HCL.matrix[5][5] = 0.0f;
        HCL HCE2 = new HCL(matrix, labels);
        System.out.println(HCE2.get_NewickFormat_HCL());
    }
}

