/*
 * Decompiled with CFR 0.152.
 */
package medusa.example;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import medusa.MedusaSettings;
import medusa.display.BasicGraphPanel;
import medusa.example.NodeIcon;
import medusa.graph.Edge;
import medusa.graph.Node;

public class ExamplePanel
extends BasicGraphPanel {
    BufferedImage red;
    NodeIcon ni = new NodeIcon();

    public ExamplePanel(MedusaSettings ms) {
        super(ms);
        this.red = this.ni.createGlossyButton(Color.RED, 10);
    }

    @Override
    public void paintEdge(Graphics2D g, Edge e) {
        g.setPaint(this.basicEdgeColor);
        this.paintPath(g, e);
    }

    private void paintPath(Graphics2D g2d, Edge e) {
        Node from = this.graph.getNode(e.getFromName());
        Node to = this.graph.getNode(e.n2);
        int x1 = (int)from.getX();
        int y1 = (int)from.getY();
        int x2 = (int)to.getX();
        int y2 = (int)to.getY();
        g2d.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void paintNode(Graphics2D g, Node n) {
        this.paintNodeImage(g, n);
    }

    private void paintNodeImage(Graphics2D g, Node n) {
        int x = (int)n.getX() - this.nodeSize / 2;
        int y = (int)n.getY() - this.nodeSize / 2;
        g.drawImage(this.red, null, x, y);
    }

    private void paintShadedNode(Graphics2D g, Node n) {
        Color c = n.getColor();
        int nodeSize = 16;
        int border = 2;
        int x = (int)n.getX() - nodeSize / 2;
        int y = (int)n.getY() - nodeSize / 2;
        float fx = x;
        float fy = y;
        Point2D.Float p1 = new Point2D.Float(x, y);
        Point2D.Float p2 = new Point2D.Float(x + nodeSize, y + nodeSize);
        GradientPaint outside = new GradientPaint(p1, c, p2, Color.white);
        GradientPaint inside = new GradientPaint(p1, Color.white, p2, c);
        Ellipse2D.Double outsideShape = new Ellipse2D.Double(x, y, nodeSize, nodeSize);
        Ellipse2D.Double insideShape = new Ellipse2D.Double(x + border, y + border, nodeSize - 2 * border, nodeSize - 2 * border);
        g.setPaint(outside);
        g.fill(outsideShape);
        g.setPaint(inside);
        g.fill(insideShape);
        g.setPaint(Color.black);
        if (this.label) {
            g.drawString(n.getLabel(), x - 2, y - 2);
        }
    }
}

