/*
 * Decompiled with CFR 0.152.
 */
package medusa.display;

import java.awt.Color;
import java.awt.Graphics2D;
import medusa.MedusaSettings;
import medusa.display.BasicGraphPanel;
import medusa.graph.Edge;
import medusa.graph.Node;

public class SamplePanel
extends BasicGraphPanel {
    public SamplePanel(MedusaSettings ms) {
        super(ms);
    }

    @Override
    public void paintEdge(Graphics2D g, Edge e) {
        g.setPaint(this.basicEdgeColor);
        this.paintPathWithConfLabel(g, e);
    }

    public void paintPathWithConfLabel(Graphics2D g2d, Edge e) {
        Node from = this.graph.getNode(e.getFromName());
        Node to = this.graph.getNode(e.n2);
        int x1 = (int)from.getX();
        int y1 = (int)from.getY();
        int x2 = (int)to.getX();
        int y2 = (int)to.getY();
        float conf = e.getConf();
        String conf_string = Float.toString(conf);
        int lastIndex = conf_string.length();
        int last = Math.min(lastIndex, 3);
        conf_string = conf_string.substring(0, last);
        g2d.drawLine(x1, y1, x2, y2);
        int width = 11;
        int height = 6;
        int halfx = (x1 + x2) / 2;
        int halfy = (y1 + y2) / 2;
        g2d.setColor(Color.YELLOW.brighter());
        g2d.fillRect(halfx - width, halfy - height, width * 2, height * 2);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(halfx - width, halfy - height, width * 2, height * 2);
        g2d.setColor(Color.BLACK);
        g2d.drawString(conf_string, halfx - width + 1, halfy + height - 1);
    }
}

