/*
 * Decompiled with CFR 0.152.
 */
package medusa.display;

import java.io.Serializable;
import java.util.Iterator;
import medusa.graph.Graph;
import medusa.graph.Node;
import medusa.graph.UniqueEdge;

public class FRspring
implements Runnable {
    private int width;
    private int height;
    private double critXDistance;
    private double critYDistance;
    private int area;
    private double k;
    private Graph g;
    private double temp;
    private Thread me;
    private boolean done = true;
    private static final double LIMIT = 1.0E-10;
    static int MAX_ITERATIONS = 300;
    private int iterations = 0;
    int borderSize = 20;

    public FRspring(int width, int height) {
        this.width = width;
        this.height = height;
        this.area = width * height;
        this.temp = width / 10;
        this.critXDistance = width * 3 / 4;
        this.critYDistance = height * 3 / 4;
    }

    public FRspring(Graph g, int width, int height) {
        this.g = g;
        this.width = width;
        this.height = height;
        this.area = width * height;
        this.temp = width / 10;
        this.critXDistance = width * 3 / 4;
        this.critYDistance = height * 3 / 4;
        this.setK();
    }

    private void setK() {
        this.k = 0.8 * Math.sqrt(this.area / this.g.getNodeSize());
    }

    private double[] attractDistance(Node aNode, Node bNode) {
        double xDelta = aNode.getX() - bNode.getX();
        double yDelta = aNode.getY() - bNode.getY();
        double delta = Math.sqrt(xDelta * xDelta + yDelta * yDelta);
        double[] result = new double[2];
        delta = Math.max(delta, 1.0E-10);
        double force = delta * delta / this.k;
        result[0] = xDelta / delta * force;
        result[1] = yDelta / delta * force;
        return result;
    }

    private double[] repelDistance(Node aNode, Node bNode) {
        double xDelta = aNode.getX() - bNode.getX();
        double yDelta = aNode.getY() - bNode.getY();
        if (xDelta > this.critXDistance) {
            xDelta = aNode.getX() - bNode.getX() - (double)this.width;
        }
        if (xDelta < -this.critXDistance) {
            xDelta = aNode.getX() - bNode.getX() + (double)this.width;
        }
        if (yDelta > this.critYDistance) {
            yDelta = aNode.getY() - bNode.getY() - (double)this.height;
        }
        if (yDelta < -this.critYDistance) {
            yDelta = aNode.getY() - bNode.getY() + (double)this.height;
        }
        double delta = Math.sqrt(xDelta * xDelta + yDelta * yDelta);
        delta = Math.max(delta, 1.0E-10);
        double[] result = new double[2];
        double force = this.k * this.k / delta;
        result[0] = xDelta / delta * force;
        result[1] = yDelta / delta * force;
        return result;
    }

    public void iterateAll() {
        this.done = false;
        for (int i = 0; i < MAX_ITERATIONS; ++i) {
            this.moveNodes();
        }
        this.done = true;
    }

    public void start() {
        if (this.me == null) {
            this.me = new Thread(this);
        }
        this.me.start();
    }

    public void stop() {
        if (this.me != null) {
            this.me = null;
        }
    }

    @Override
    public void run() {
        Thread myThread = Thread.currentThread();
        if (this.me == myThread) {
            this.iterateAll();
        }
    }

    public int getCurrent() {
        return this.iterations;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean iterate() {
        if (this.iterations < MAX_ITERATIONS) {
            this.moveNodes();
            return true;
        }
        return false;
    }

    public void moveNodes() {
        Node node2;
        Node node;
        ++this.iterations;
        double[] displacement = new double[2];
        Iterator<Serializable> it = this.g.nodesIterator();
        while (it.hasNext()) {
            node = it.next();
            node.setDX(0.0);
            node.setDY(0.0);
            Iterator<Node> it2 = this.g.nodesIterator();
            while (it2.hasNext()) {
                node2 = it2.next();
                if (node.equals(node2)) continue;
                displacement = this.repelDistance(node, node2);
                node.setDX(node.getDX() + displacement[0]);
                node.setDY(node.getDY() + displacement[1]);
            }
        }
        it = this.g.uniqueEdgesIterator();
        while (it.hasNext()) {
            UniqueEdge edge = (UniqueEdge)it.next();
            node = this.g.getNode(edge.getFromName());
            node2 = this.g.getNode(edge.getToName());
            displacement = this.attractDistance(node, node2);
            node.setDX(node.getDX() - displacement[0]);
            node.setDY(node.getDY() - displacement[1]);
            node2.setDX(node2.getDX() + displacement[0]);
            node2.setDY(node2.getDY() + displacement[1]);
        }
        it = this.g.nodesIterator();
        while (it.hasNext()) {
            node = (Node)it.next();
            if (node.isFixed()) continue;
            node.setX(node.getX() + Math.max(-this.temp, Math.min(node.getDX(), this.temp)));
            node.setY(node.getY() + Math.max(-this.temp, Math.min(node.getDY(), this.temp)));
            if (node.getX() > (double)this.width) {
                node.setX((double)(this.width - this.borderSize) - 10.0 * Math.random());
            }
            if (node.getX() < (double)this.borderSize) {
                node.setX((double)this.borderSize + 10.0 * Math.random());
            }
            if (node.getY() > (double)this.height) {
                node.setY((double)(this.height - this.borderSize) - 10.0 * Math.random());
            }
            if (!(node.getY() < (double)(this.borderSize + 10))) continue;
            node.setY((double)(2 * this.borderSize) + 10.0 * Math.random());
        }
        this.cool();
    }

    public void setBorderSize(int borderSize) {
        this.borderSize = borderSize;
    }

    private void cool() {
        this.temp *= 1.0 - (double)this.iterations / (double)MAX_ITERATIONS;
    }

    public static void main(String[] args) {
        FRspring frSpring = new FRspring(400, 400);
        frSpring.setK();
        for (int i = 0; i < 18; ++i) {
            System.out.println("move " + i);
            frSpring.moveNodes();
        }
    }
}

