/*
 * Decompiled with CFR 0.152.
 */
package medusa.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import medusa.DataFormatException;
import medusa.MedusaSettings;
import medusa.MedusaSimplerFrame;
import medusa.dataio.DataLoader;
import medusa.display.BasicGraphPanel;
import medusa.display.EdgeDialog;
import medusa.georgios.Browser;
import medusa.graph.Edge;
import medusa.graph.Graph;
import medusa.graph.Node;

public class EditableGraphPanel
extends BasicGraphPanel {
    BufferedImage image = null;
    Image tempImage = null;
    public boolean showBorder = true;
    protected boolean showName = true;
    Frame f = new Frame();
    int startx;
    int starty;
    int endx;
    int endy;
    boolean drawTempLine = false;
    Node temp1 = null;
    Node temp2 = null;
    boolean[] showEdges;
    int border = 10;
    JPopupMenu popup;
    JMenuItem removeItem;
    JMenuItem editColorItem;
    JMenuItem editShapeItem;
    JMenuItem setAnnotationItem;
    JMenuItem getPositionItem;
    JMenu URLItem;
    JMenuItem setURLItem;
    JMenuItem setClusterItem;
    JMenuItem gotoURLItem;
    DataLoader dl = new DataLoader(this.getPanelWidth(), this.getPanelHeight());
    public static int EXTREME_LEFT = 9001;
    public static int EXTREME_RIGHT = 9002;
    public static int EXTREME_TOP = 9003;
    public static int EXTREME_BOTTOM = 9004;

    public EditableGraphPanel(MedusaSettings stringSettings) {
        super(stringSettings);
        this.initPopup();
        this.tryImage();
        this.initShow();
    }

    public EditableGraphPanel() {
        this.initPopup();
        this.tryImage();
        this.initShow();
    }

    private void tryImage() {
        try {
            this.setImage();
            this.tempImage = this.image;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setImage() throws IOException {
        this.setImage("netview_default.png");
    }

    public void setImage(String imageURL) throws IOException {
        File imageFile = new File(imageURL);
        this.image = ImageIO.read(imageFile);
    }

    public void setImage(BufferedImage myImage) throws InterruptedException {
        this.image = myImage;
    }

    public void clearImage() {
        this.image = null;
    }

    public void drawBackgroundImage(Graphics2D g2d) {
        if (this.image == null) {
            return;
        }
        Dimension d = this.getPreferredSize();
        g2d.drawImage(this.image, 0, 0, d.width, d.height, null);
    }

    @Override
    public void paintEdge(Graphics2D g, Edge e) {
        if (!this.showEdges[e.getType() - 1]) {
            return;
        }
        super.paintEdge(g, e);
    }

    public void setShowBorder(boolean show) {
        this.showBorder = show;
    }

    @Override
    public void paintNet(Graphics2D g2d) {
        if (this.showBorder) {
            Rectangle2D.Double border = new Rectangle2D.Double(2.0, 2.0, this.getPanelWidth(), this.getPanelHeight());
            g2d.draw(border);
        }
        Iterator<Edge> edges = this.graph.edgesIterator();
        while (edges.hasNext()) {
            Edge e = edges.next();
            int col = e.getType();
            if (!this.showEdges[col - 1]) continue;
            this.paintEdge(g2d, e);
        }
        g2d.setComposite(this.makeComposite(1.0f));
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            this.paintNode(g2d, node);
        }
    }

    @Override
    public void saveImage(String path, int param) {
        this.setShowBorder(false);
        super.saveImage(path, param);
        this.setShowBorder(true);
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        Graphics2D g2d = this.prePaint(g);
        this.drawBackgroundImage(g2d);
        if (this.hideWhenMove) {
            if (!this.running & this.pick != null) {
                this.paintVisibleNet(g2d);
            } else {
                this.paintNet(g2d);
            }
        } else {
            this.paintNet(g2d);
        }
        this.drawBox(g2d);
        if (this.drawTempLine) {
            float[] dashPattern = new float[]{2.0f, 3.0f, 2.0f, 3.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f));
            g2d.drawLine(this.startx, this.starty, this.endx, this.endy);
        }
        g2d.setStroke(new BasicStroke(1.0f));
    }

    public void paintVisibleNet(Graphics2D g2d) {
        if (this.showBorder) {
            Rectangle2D.Double border = new Rectangle2D.Double(2.0, 2.0, this.getPanelWidth(), this.getPanelHeight());
            g2d.draw(border);
        }
        Iterator<Edge> edges = this.getVisibleGraph().edgesIterator();
        while (edges.hasNext()) {
            Edge e = edges.next();
            int col = e.getType();
            if (!this.showEdges[col - 1]) continue;
            this.paintEdge(g2d, e);
        }
        g2d.setComposite(this.makeComposite(1.0f));
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            this.paintNode(g2d, node);
        }
    }

    protected void drawBox(Graphics2D g2d) {
        if (this.getCurrentRect() != null) {
            g2d.setXORMode(Color.red);
            float[] dashPattern = new float[]{2.0f, 3.0f, 2.0f, 3.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f));
            g2d.drawRect(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width - 1, this.rectToDraw.height - 1);
        }
    }

    public void setShowName(boolean b) {
        this.showName = b;
        this.showAnnotation = !b;
    }

    private void handleRightMouseDragged(MouseEvent e) {
        if ((e.getModifiers() & 4) != 0) {
            this.drawTempLine = true;
            this.endx = e.getX();
            this.endy = e.getY();
            this.repaint();
        }
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleLeftMouseDragged(e);
        this.handleRightMouseDragged(e);
    }

    public void handleReleaseRightButton(MouseEvent e) {
        if (e.getButton() != 3) {
            return;
        }
        this.removeMouseMotionListener(this);
        Node node = this.getClosest(e);
        this.temp2 = node != null ? node : new Node("unnamed", e.getX(), e.getY());
        this.drawTempLine = false;
        this.endx = e.getX();
        this.endy = e.getY();
        if (this.temp1 != this.temp2) {
            this.addEdge();
            this.repaint();
            this.temp1 = null;
            this.temp2 = null;
        } else {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleReleaseLeftButton(e);
        this.handleReleaseRightButton(e);
    }

    private void handlePressRightButton(MouseEvent e) {
        if (e.getButton() == 3) {
            this.addMouseMotionListener(this);
            Node node = this.getClosest(e);
            if (node != null) {
                this.temp1 = node;
                this.startx = (int)this.temp1.getX();
                this.starty = (int)this.temp1.getY();
            } else {
                this.startx = e.getX();
                this.starty = e.getY();
                this.temp1 = new Node("unnamed", this.startx, this.starty);
            }
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handlePressLeftButton(e);
        this.handlePressRightButton(e);
    }

    protected void addEdge() {
        Edge e = EdgeDialog.showDialog(this.f, null, this.temp1, this.temp2, this.getStringSettings());
        if (e != null) {
            this.temp1.setLabel(e.getFromName());
            this.temp2.setLabel(e.getToName());
            this.graph.addEdge(e);
            this.graph.setNode(this.temp1);
            this.graph.setNode(this.temp2);
            this.updateNodes();
        }
    }

    public void initShow() {
        int max = 40;
        this.showEdges = new boolean[40];
        for (int i = 0; i < 40; ++i) {
            this.showEdges[i] = true;
        }
    }

    public void setShowEdge(int i, boolean b) {
        this.showEdges[i] = b;
    }

    public void setHideEdge(int i, boolean b) {
        this.showEdges[i] = !b;
    }

    public void setShape(int shape) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (!node.isFixed()) continue;
            node.setShape(shape);
        }
    }

    private void initPopup() {
        this.popup = new JPopupMenu("Edit data");
        this.removeItem = new JMenuItem("Delete");
        this.editColorItem = new JMenuItem("Color");
        this.editShapeItem = new JMenuItem("Shape");
        this.setAnnotationItem = new JMenuItem("Annotation");
        this.URLItem = new JMenu("URL");
        this.gotoURLItem = new JMenuItem("Go to page");
        this.setURLItem = new JMenuItem("Edit URL");
        this.setClusterItem = new JMenuItem("Edit Predefined Cluster");
        this.getPositionItem = new JMenuItem("Position");
        this.removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditableGraphPanel.this.temp1 != null) {
                    EditableGraphPanel.this.removeEdgeByLabel(EditableGraphPanel.this.temp1.getLabel());
                    EditableGraphPanel.this.temp1 = null;
                    EditableGraphPanel.this.temp2 = null;
                    EditableGraphPanel.this.repaint();
                } else {
                    System.out.println("node is null, for some strange reason");
                }
            }
        });
        this.editColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(EditableGraphPanel.this.getRootPane(), "Choose node color", EditableGraphPanel.this.temp1.getColor());
                if (newColor != null) {
                    EditableGraphPanel.this.temp1.setColor(newColor);
                }
                EditableGraphPanel.this.repaint();
            }
        });
        this.editShapeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableGraphPanel.this.temp1.setShape(EditableGraphPanel.this.chooseShape());
                EditableGraphPanel.this.repaint();
            }
        });
        this.setAnnotationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableGraphPanel.this.setAnnotation(EditableGraphPanel.this.temp1);
            }
        });
        this.setURLItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableGraphPanel.this.setURL(EditableGraphPanel.this.temp1);
            }
        });
        this.setClusterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableGraphPanel.this.setPredefinedCluster(EditableGraphPanel.this.temp1);
            }
        });
        this.gotoURLItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditableGraphPanel.this.temp1.getURL().startsWith("http://")) {
                    Browser.openURL(EditableGraphPanel.this.temp1.getURL());
                }
            }
        });
        this.getPositionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableGraphPanel.this.getPosition(EditableGraphPanel.this.temp1);
            }
        });
        this.popup.add(this.removeItem);
        this.popup.addSeparator();
        this.popup.add(this.editColorItem);
        this.popup.add(this.editShapeItem);
        this.popup.add(this.setAnnotationItem);
        this.popup.add(this.URLItem);
        this.URLItem.add(this.setURLItem);
        this.popup.add(this.setClusterItem);
        this.URLItem.add(this.gotoURLItem);
        this.popup.add(this.getPositionItem);
    }

    private void getPosition(Node temp) {
        JOptionPane.showMessageDialog(MedusaSimplerFrame.stringletPanel, "x: " + temp.getX() + " y:" + temp.getY());
    }

    private void setAnnotation(Node temp) {
        String s = JOptionPane.showInputDialog("View or edit node annotation:\n", (Object)temp.getAnnotation());
        if (s != null && s.length() > 0) {
            temp.setAnnotation(s);
        }
    }

    private void setURL(Node temp) {
        String s = JOptionPane.showInputDialog("View or edit node URL:\n", (Object)temp.getURL());
        if (s != null && s.length() > 0) {
            if (!s.startsWith("http://")) {
                JOptionPane.showMessageDialog(MedusaSimplerFrame.stringletPanel, "URL does not start with http://");
            } else {
                temp.setURL(s);
            }
        }
    }

    private void setPredefinedCluster(Node temp) {
        String s = JOptionPane.showInputDialog("View or edit node predefined cluster:\n", (Object)temp.getCLuster());
        if (s != null && s.matches("[0-9]+")) {
            if (Integer.parseInt(s) >= 1 || Integer.parseInt(s) == -1) {
                temp.setCluster(s);
            } else {
                JOptionPane.showMessageDialog(MedusaSimplerFrame.stringletPanel, "Cluster takes a positive value >1 or -1 for no cluster");
            }
        }
    }

    private int chooseShape() {
        Object[] shapes = new Object[]{"circle", "rectangle", "triangle", "diamond"};
        int s = JOptionPane.showOptionDialog(this, "Choose a node shape", "Shape", 1, 3, null, shapes, "circle");
        return s;
    }

    private void showPopup(MouseEvent e) {
        this.popup.show(e.getComponent(), e.getX(), e.getY());
        e.consume();
    }

    public ArrayList getFixed() {
        return this.graph.getFixed();
    }

    public void copyNodeSettings(Graph g) {
        this.graph.copyNodeSettings(g);
    }

    public void removeEdgeByLabel(String label) {
        this.graph.removeEdgeByLabel(label);
    }

    public void removeFixedNodes() {
        this.graph.removeFixed();
    }

    public void crop(double confidence) {
        this.graph.cropEdges(confidence);
        this.calculateEdgeLength();
    }

    public void markNode(Graphics2D g2d, Node markedNode) {
        if (markedNode == null) {
            return;
        }
        int refX = this.getPanelWidth() / 2;
        int refY = this.getPanelHeight() / 2;
        double r45 = 0.4487989505128276;
        double deltaLength = 15.0;
        double headLength = 13.0;
        double x = markedNode.getX();
        double y = markedNode.getY();
        double deltaX = x - (double)refX;
        double deltaY = -(y - (double)refY);
        double theta = Math.atan(deltaY / deltaX);
        if (deltaX < 0.0) {
            theta += Math.PI;
        }
        int xh = (int)(x - deltaLength * Math.cos(theta));
        int yh = (int)(y + deltaLength * Math.sin(theta));
        int xc = (int)((double)xh - headLength * Math.cos(theta - r45));
        int yc = (int)((double)yh + headLength * Math.sin(theta - r45));
        int xa = (int)((double)xh - headLength * Math.cos(theta + r45));
        int ya = (int)((double)yh + headLength * Math.sin(theta + r45));
        int shad = 3;
        int[] xpoints = new int[]{xc, xh, xa};
        int[] ypoints = new int[]{yc, yh, ya};
        int[] shadowX = new int[]{xc + shad, xh + shad, xa + shad};
        int[] shadowY = new int[]{yc + shad, yh + shad, ya + shad};
        int npoints = 3;
        g2d.setColor(Color.black);
        g2d.fillPolygon(shadowX, shadowY, npoints);
        g2d.setColor(Color.orange);
        g2d.fillPolygon(xpoints, ypoints, npoints);
        g2d.setColor(Color.black);
    }

    public int selectNodeByRegExp(String regexp, boolean label) {
        int matches = 0;
        Pattern labelPattern = Pattern.compile(regexp);
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            String toMatch = label ? node.getLabel() : node.getAnnotation();
            Matcher matcher = labelPattern.matcher(toMatch);
            if (!matcher.find()) continue;
            node.setFixed(true);
            ++matches;
        }
        return matches;
    }

    public int selectNodeFromFile(String fileName) throws IOException {
        String inLine;
        int matches = 0;
        File loadFile = new File(fileName);
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(loadFile)));
        while ((inLine = in.readLine()) != null) {
            Iterator<Node> it = this.graph.nodesIterator();
            while (it.hasNext()) {
                Node node = it.next();
                if (node.getLabel().compareTo(inLine) != 0) continue;
                ++matches;
                node.setFixed(true);
            }
        }
        in.close();
        return matches;
    }

    public void manipulateColor(int a, int b, boolean doSwitch) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (!node.isFixed()) continue;
            node.manipulateColorElement(a, b, doSwitch);
        }
    }

    public void addGradientX(int channel) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (!node.isFixed()) continue;
            int value = (int)(node.getX() / (double)this.getPanelWidth() * 255.0);
            node.manipulateChannel(channel, value);
        }
    }

    public void addGradientY(int channel) {
        Iterator<Node> it = this.graph.nodesIterator();
        while (it.hasNext()) {
            Node node = it.next();
            if (!node.isFixed()) continue;
            int value = (int)(node.getY() / (double)this.getPanelWidth() * 255.0);
            node.manipulateChannel(channel, value);
        }
    }

    public void clearGraph() {
        this.graph.clear();
        this.updateNodes();
    }

    public void loadGraph(String fileName) throws IOException, DataFormatException {
        this.graph = this.dl.load(fileName);
        this.updateNodes();
    }

    public void saveGraph(String fileName) throws IOException {
        this.dl.save(this.graph, fileName, this.scale);
        this.updateNodes();
    }

    public void writePajek(String fileName) throws IOException {
        this.dl.saveAsPajek(this.graph, fileName);
    }

    public void writeArena3D(String fileName) throws IOException {
        this.dl.saveAsArena3D(this.graph, fileName);
    }

    public void writeCytoscape(String fileName) throws IOException {
        this.dl.saveAsCytoscape(this.graph, fileName);
    }

    public void writeGraphViz(String fileName) throws IOException {
        this.dl.saveAsGraphViz(this.graph, fileName);
    }

    public void writeBiolayout(String fileName) throws IOException {
        this.dl.saveAsBiolayout(this.graph, fileName);
    }

    public void writePS(String fileName) throws IOException {
        this.dl.saveAsPS(this.graph, fileName, this.getStringSettings(), this.nodeSize, this.fontSize);
    }

    public void writeEPS(String fileName) throws IOException {
        this.dl.saveAsEPS(this.graph, fileName, this.getStringSettings(), this.nodeSize, this.fontSize);
    }

    public void appendGraph(String fileName) throws IOException, DataFormatException {
        Graph temp = this.dl.load(fileName);
        this.graph.addGraph(temp);
        this.copyNodeSettings(temp);
        this.calculateEdgeLength();
        this.updateNodes();
    }

    public void subtractGraph(String fileName) throws IOException, DataFormatException {
        Graph temp = this.dl.load(fileName);
        this.graph.subtractGraph(temp);
        this.copyNodeSettings(temp);
        this.calculateEdgeLength();
        this.updateNodes();
    }

    public void copyGraphSettings(String fileName) throws IOException, DataFormatException {
        Graph temp = this.dl.load(fileName);
        this.copyNodeSettings(temp);
        this.updateNodes();
    }

    public void addGraph(Graph g) {
        if (g == null) {
            return;
        }
        g.rescaleNodes(600);
        this.graph.addGraph(g);
        this.copyNodeSettings(g);
    }

    public void growSelection() {
        this.graph.growSelection();
    }

    public void alignNodes(int align) {
        ArrayList nodes = this.getFixed();
        boolean y = false;
        Node node = this.getExtremeNode(align, nodes);
        if (node == null) {
            return;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            Node n = (Node)nodes.get(i);
            if (align == EXTREME_LEFT || align == EXTREME_RIGHT) {
                n.setY(node.getY());
            }
            if (align != EXTREME_TOP && align != EXTREME_BOTTOM) continue;
            n.setX(node.getX());
        }
    }

    public Node getExtremeNode(int extreme, List<Node> nodes) {
        double leftValue = Double.MAX_VALUE;
        double topValue = Double.MAX_VALUE;
        double rightValue = 0.0;
        double bottomValue = 0.0;
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            Node n = nodes.get(i);
            if (n.getX() < leftValue) {
                leftValue = n.getX();
                left = i;
            }
            if (n.getX() > rightValue) {
                rightValue = n.getX();
                right = i;
            }
            if (n.getY() < topValue) {
                topValue = n.getY();
                top = i;
            }
            if (!(n.getY() > bottomValue)) continue;
            bottomValue = n.getY();
            bottom = i;
        }
        if (extreme == EXTREME_LEFT) {
            return nodes.get(left);
        }
        if (extreme == EXTREME_RIGHT) {
            return nodes.get(right);
        }
        if (extreme == EXTREME_TOP) {
            return nodes.get(top);
        }
        if (extreme == EXTREME_BOTTOM) {
            return nodes.get(bottom);
        }
        return null;
    }
}

