/*
 * Decompiled with CFR 0.152.
 */
package medusa.applet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JApplet;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import medusa.MedusaSettings;
import medusa.applet.MedusaAppletPanel;
import medusa.dataio.DataLoader;
import medusa.display.BasicGraphPanel;
import medusa.georgios.Layouts.Layouts;
import medusa.graph.Graph;

public class MedusaLite
extends JApplet
implements ItemListener,
ActionListener {
    final Color babyBlue = new Color(230, 226, 230);
    public BasicGraphPanel panel;
    private MedusaSettings stringSettings;
    private JScrollPane jScrollPane;
    public JPanel controlPanel = new JPanel();
    private int xParam;
    private int yParam;
    JCheckBox relax = new JCheckBox("Relax", false);
    JCheckBox pretty = new JCheckBox("Edge colours", true);
    JCheckBox names = new JCheckBox("Labels", true);
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenuItem randomButton = new JMenuItem("Random");
    JMenu layout_menu = new JMenu("Layout");
    JMenu clustering_menu = new JMenu("Clustering");
    JMenuItem circularButton = new JMenuItem("Circular");
    JMenuItem gridButton = new JMenuItem("Grid");
    JMenuItem hierarchicalButton = new JMenuItem("Hierarchical");
    JMenuItem geometryButton = new JMenuItem("Distance Geometry");
    JMenuItem kmeansButton = new JMenuItem("k-means");
    JMenuItem affinityButton = new JMenuItem("Affinity Propagation");
    JMenuItem mclButton = new JMenuItem("Markov Clustering");
    JMenuItem predefinedButton = new JMenuItem("Predefined Clustering");
    JMenuItem frButton = new JMenuItem("Fruchterman");
    JMenuItem imageButton = new JMenuItem("Export");

    public void initPanel() {
        System.out.println("Initializing MedusaAppletPanel");
        String settingsParam = this.getParameter("settings");
        this.setLocalStringSettings(new MedusaSettings(settingsParam));
        String linkStart = this.getParameter("linkStart");
        String linkEnd = this.getParameter("linkEnd");
        System.out.println(linkStart);
        this.setPanel(new MedusaAppletPanel(this.getLocalStringSettings(), this, linkStart, linkEnd));
        this.getPanel().stop();
    }

    @Override
    public void init() {
        int myX = this.getParameter("X") == null ? 900 : Integer.parseInt(this.getParameter("X"));
        int myY = this.getParameter("Y") == null ? 900 : Integer.parseInt(this.getParameter("Y"));
        System.out.println("size: " + myX + " " + myY);
        this.initPanel();
        DataLoader dl = new DataLoader(myX, myY);
        String edges = this.getParameter("edges");
        String nodes = this.getParameter("nodes");
        Graph g = dl.readParameters(edges, nodes);
        if (g == null) {
            throw new RuntimeException("Graph is null!");
        }
        dl.convertToRealDistances(g);
        this.panel.setGraph(g);
        this.setPrefs();
        String layoutParam = this.getParameter("layout");
        if (layoutParam != null && layoutParam.compareTo("true") == 0) {
            this.getPanel().energy();
        }
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        this.setJScrollPane(new JScrollPane(this.getPanel()));
        content.add("Center", this.getJScrollPane());
        this.controlPanel = new JPanel();
        this.populateControlPanel();
        content.add("South", this.controlPanel);
    }

    public void setPrefs() {
        this.getPanel().setPretty(true);
        this.getPanel().setArrows(false);
        this.getPanel().setLabel(true);
        this.getPanel().setConfidence(true);
        this.getPanel().setCool(true);
        this.getPanel().repaint();
    }

    public void populateControlPanel() {
        this.controlPanel.setLayout(new GridLayout(1, 5));
        this.controlPanel.setBackground(this.babyBlue);
        this.relax.setBackground(this.babyBlue);
        this.pretty.setBackground(this.babyBlue);
        this.names.setBackground(this.babyBlue);
        this.layout_menu.setBackground(this.babyBlue);
        this.clustering_menu.setBackground(this.babyBlue);
        this.controlPanel.add(this.relax);
        this.relax.addItemListener(this);
        this.controlPanel.add(this.pretty);
        this.pretty.addItemListener(this);
        this.controlPanel.add(this.names);
        this.names.addItemListener(this);
        this.layout_menu.add(this.frButton);
        this.frButton.setBackground(this.babyBlue);
        this.frButton.addActionListener(this);
        this.layout_menu.add(this.randomButton);
        this.randomButton.setBackground(this.babyBlue);
        this.randomButton.addActionListener(this);
        this.layout_menu.add(this.circularButton);
        this.circularButton.setBackground(this.babyBlue);
        this.circularButton.addActionListener(this);
        this.layout_menu.add(this.gridButton);
        this.gridButton.setBackground(this.babyBlue);
        this.gridButton.addActionListener(this);
        this.layout_menu.add(this.hierarchicalButton);
        this.hierarchicalButton.setBackground(this.babyBlue);
        this.hierarchicalButton.addActionListener(this);
        this.layout_menu.add(this.geometryButton);
        this.geometryButton.setBackground(this.babyBlue);
        this.geometryButton.addActionListener(this);
        this.clustering_menu.add(this.predefinedButton);
        this.predefinedButton.setBackground(this.babyBlue);
        this.predefinedButton.addActionListener(this);
        this.clustering_menu.add(this.kmeansButton);
        this.kmeansButton.setBackground(this.babyBlue);
        this.kmeansButton.addActionListener(this);
        this.clustering_menu.add(this.affinityButton);
        this.affinityButton.setBackground(this.babyBlue);
        this.affinityButton.addActionListener(this);
        this.clustering_menu.add(this.mclButton);
        this.mclButton.setBackground(this.babyBlue);
        this.mclButton.addActionListener(this);
        this.jMenuBar1.add(this.layout_menu);
        this.jMenuBar1.add(this.clustering_menu);
        this.controlPanel.add(this.jMenuBar1);
        this.getPanel().repaint();
    }

    @Override
    public void destroy() {
        this.remove(this.panel);
    }

    @Override
    public void start() {
    }

    public void startRelax() {
        this.getPanel().start();
    }

    public void stopRelax() {
        this.getPanel().stop();
    }

    @Override
    public void stop() {
        this.panel.stop();
    }

    @Override
    public String getAppletInfo() {
        return "Title: MedusaLite \nAuthor: Sean Hooper  and  Georgios Pavlopoulos";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Graph g;
        Object es = e.getSource();
        if (es == this.frButton) {
            this.relax.setSelected(false);
            this.getPanel().energy();
        }
        if (es == this.randomButton) {
            this.getPanel().stop();
            g = this.getPanel().getGraph();
            Layouts.Apply_Random_Coordinates(g, this.getPanel());
            this.getPanel().repaint();
        }
        if (es == this.gridButton) {
            this.getPanel().stop();
            g = this.getPanel().getGraph();
            Layouts.Apply_Grid_Coordinates(g, this.getPanel());
            this.getPanel().repaint();
        }
        if (es == this.circularButton) {
            this.getPanel().stop();
            g = this.getPanel().getGraph();
            Layouts.Apply_Circular_Coordinates(g, this.getPanel());
            this.getPanel().repaint();
        }
        if (es == this.hierarchicalButton) {
            this.getPanel().stop();
            g = this.getPanel().getGraph();
            Layouts.Apply_GO_like_Coordinates(g, this.getPanel());
            this.getPanel().repaint();
        }
        if (es == this.geometryButton) {
            this.getPanel().stop();
            g = this.getPanel().getGraph();
            Layouts.Apply_Distance_Geomretry_Coordinates(g, this.getPanel());
            this.getPanel().repaint();
        }
        if (es == this.kmeansButton) {
            this.getPanel().stop();
            g = this.getPanel().getGraph();
            Layouts.Apply_Kmeans_Clustering(g, this.getPanel());
            this.getPanel().repaint();
        }
        if (es == this.affinityButton) {
            this.getPanel().stop();
            g = this.getPanel().getGraph();
            Layouts.Apply_Affinity_Propagation_Clustering(g, this.getPanel());
            this.getPanel().repaint();
        }
        if (es == this.mclButton) {
            this.getPanel().stop();
            g = this.getPanel().getGraph();
            Layouts.Apply_MCL_Propagation_Clustering(g, this.getPanel());
            this.getPanel().repaint();
        }
        if (es == this.predefinedButton) {
            this.getPanel().stop();
            g = this.getPanel().getGraph();
            Layouts.Apply_Predefined_Clustering(g, this.getPanel());
            this.getPanel().repaint();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src == this.relax) {
            if (this.relax.isSelected()) {
                this.startRelax();
            } else {
                this.stopRelax();
            }
        }
        if (src == this.pretty) {
            this.getPanel().setPretty(this.pretty.isSelected());
            this.getPanel().repaint();
        }
        if (src == this.names) {
            this.getPanel().setLabel(this.names.isSelected());
            this.getPanel().repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public void setLocalStringSettings(MedusaSettings stringSettings) {
        this.stringSettings = stringSettings;
    }

    public void setPanel(BasicGraphPanel panel) {
        this.panel = panel;
    }

    public BasicGraphPanel getPanel() {
        return this.panel;
    }

    public int getXParam() {
        return this.xParam;
    }

    public void setXParam(int xParam) {
        this.xParam = xParam;
    }

    public int getYParam() {
        return this.yParam;
    }

    public void setYParam(int yParam) {
        this.yParam = yParam;
    }

    public MedusaSettings getLocalStringSettings() {
        return this.stringSettings;
    }

    public JScrollPane getJScrollPane() {
        return this.jScrollPane;
    }

    public void setJScrollPane(JScrollPane jScrollPane) {
        this.jScrollPane = jScrollPane;
    }

    public void setHideWhenMoveJS(boolean hwm) {
        this.getPanel().setHideWhenMove(hwm);
    }

    public void setArrowsJS(boolean arrows) {
        this.getPanel().setArrows(arrows);
        this.getPanel().repaint();
    }

    public void setPrettyJS(boolean tof) {
        this.getPanel().setPretty(tof);
        this.getPanel().repaint();
    }

    public void setConfidenceJS(boolean tof) {
        this.getPanel().setConfidence(tof);
        this.getPanel().repaint();
    }
}

